/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.jetbrains.annotations.TestOnly;

public class DdlBatchingSuggester
implements Consumer<SqlQueryType> {
    static final int THRESHOLD = 10;
    private static final IgniteLogger LOG = Loggers.forClass(DdlBatchingSuggester.class);
    private final Consumer<String> printer;
    private final AtomicInteger counter = new AtomicInteger();

    DdlBatchingSuggester() {
        this.printer = x$0 -> LOG.warn((String)x$0, new Object[0]);
    }

    @TestOnly
    DdlBatchingSuggester(Consumer<String> printer) {
        this.printer = printer;
    }

    @Override
    public void accept(SqlQueryType type) {
        if (type != SqlQueryType.DDL) {
            this.counter.set(0);
            return;
        }
        if (this.counter.incrementAndGet() == 10) {
            this.printer.accept("Multiple DDL statements were executed individually. For improved performance, consider grouping DDL statements into a single SQL script. To disable this suggestion, set the cluster property 'ignite.suggestions.sequentialDdlExecution.enabled' to 'false'.");
        }
    }

    @TestOnly
    public int trackedQueriesCount() {
        return this.counter.get();
    }
}

