/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gridgain.ml.model.ModelConfig;
import org.gridgain.ml.model.ModelType;

public class ModelInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private String version;
    private final ModelType type = ModelType.ONNX;
    private String url;
    private final ModelConfig config;
    private Map<String, String> properties;
    private boolean loaded;
    private long loadTimestamp;
    private ModelStatus status;
    private String inputClass;
    private String outputClass;
    private String translator;
    private String translatorFactory;

    protected ModelInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.version = builder.version;
        this.url = builder.url;
        this.config = builder.config;
        this.properties = builder.properties;
        this.loaded = builder.loaded;
        this.loadTimestamp = builder.loadTimestamp;
        this.status = builder.status;
        this.inputClass = builder.inputClass;
        this.outputClass = builder.outputClass;
        this.translator = builder.translator;
        this.translatorFactory = builder.translatorFactory;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public ModelType type() {
        return this.type;
    }

    public String url() {
        return this.url;
    }

    public ModelConfig config() {
        return this.config;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public long loadTimestamp() {
        return this.loadTimestamp;
    }

    public ModelStatus status() {
        return this.status;
    }

    public String inputClass() {
        return this.inputClass;
    }

    public String outputClass() {
        return this.outputClass;
    }

    public String translator() {
        return this.translator;
    }

    public String translatorFactory() {
        return this.translatorFactory;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
        if (loaded) {
            this.loadTimestamp = System.currentTimeMillis();
            this.status = ModelStatus.AVAILABLE;
        } else {
            this.loadTimestamp = 0L;
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setStatus(ModelStatus status) {
        this.status = status;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setInputClass(String inputClass) {
        this.inputClass = inputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public void setTranslator(String translator) {
        this.translator = translator;
    }

    public void setTranslatorFactory(String translatorFactory) {
        this.translatorFactory = translatorFactory;
    }

    public String property(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public String property(String key, String defaultValue) {
        return this.properties != null ? this.properties.getOrDefault(key, defaultValue) : defaultValue;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public static class Builder {
        private String id;
        private String name;
        private String version = "1.0.0";
        private ModelType type;
        private String url;
        private ModelConfig config = ModelConfig.builder().build();
        private Map<String, String> properties = new HashMap<String, String>();
        private boolean loaded = false;
        private long loadTimestamp = 0L;
        private ModelStatus status = ModelStatus.CREATING;
        private String inputClass;
        private String outputClass;
        private String translator;
        private String translatorFactory;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder type(ModelType type) {
            this.type = type;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder config(ModelConfig config) {
            this.config = config;
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder property(String key, String value) {
            return this.addProperty(key, value);
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = new HashMap<String, String>(properties);
            return this;
        }

        public Builder loaded(boolean loaded) {
            this.loaded = loaded;
            return this;
        }

        public Builder loadTimestamp(long loadTimestamp) {
            this.loadTimestamp = loadTimestamp;
            return this;
        }

        public Builder status(ModelStatus status) {
            this.status = status;
            return this;
        }

        public Builder inputClass(String inputClass) {
            this.inputClass = inputClass;
            return this;
        }

        public Builder outputClass(String outputClass) {
            this.outputClass = outputClass;
            return this;
        }

        public Builder translator(String translator) {
            this.translator = translator;
            return this;
        }

        public Builder translatorFactory(String translatorFactory) {
            this.translatorFactory = translatorFactory;
            return this;
        }

        public Builder from(ModelInfo modelInfo) {
            this.id = modelInfo.id;
            this.name = modelInfo.name;
            this.version = modelInfo.version;
            this.type = modelInfo.type;
            this.url = modelInfo.url;
            this.config = modelInfo.config;
            this.properties = new HashMap<String, String>(modelInfo.properties);
            this.loaded = modelInfo.loaded;
            this.loadTimestamp = modelInfo.loadTimestamp;
            this.status = modelInfo.status;
            this.inputClass = modelInfo.inputClass;
            this.outputClass = modelInfo.outputClass;
            this.translator = modelInfo.translator;
            this.translatorFactory = modelInfo.translatorFactory;
            return this;
        }

        public ModelInfo build() {
            if (this.id == null) {
                throw new IllegalStateException("Model ID must be specified");
            }
            if (this.name == null) {
                this.name = this.id;
            }
            if (this.type == null) {
                throw new IllegalStateException("Model type must be specified");
            }
            if (this.url == null) {
                throw new IllegalStateException("Model URL must be specified");
            }
            return new ModelInfo(this);
        }
    }

    public static enum ModelStatus {
        CREATING,
        AVAILABLE,
        DEPRECATED,
        FAILED,
        ARCHIVED;

    }
}

