/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.model;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite3.marshalling.Marshaller;
import org.gridgain.ml.model.MlJobParameters;
import org.gridgain.ml.model.ModelConfig;
import org.gridgain.ml.model.ModelInfo;

public class MlSqlJobParameters
extends MlJobParameters {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LIMIT = 1000;
    private static final int MAX_LIMIT = 5000;
    private static final int MIN_LIMIT = 1;
    private String sqlQuery;
    private Serializable[] sqlParams;
    private String inputColumn;
    private int limit;

    private MlSqlJobParameters(Builder builder) {
        super(builder);
        this.sqlQuery = builder.sqlQuery;
        this.sqlParams = builder.sqlParams;
        this.limit = builder.limit;
    }

    public String sqlQuery() {
        return this.sqlQuery;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public String inputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(String inputColumn) {
        this.inputColumn = inputColumn;
    }

    public Object[] sqlParams() {
        return this.sqlParams;
    }

    public void setSqlParams(Serializable[] sqlParams) {
        this.sqlParams = sqlParams;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        MlSqlJobParameters.validateLimit(limit);
        this.limit = limit;
    }

    private static void validateLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("limit must be at least 1, got: " + limit);
        }
        if (limit > 5000) {
            throw new IllegalArgumentException("limit cannot exceed 5000, got: " + limit);
        }
    }

    @Override
    protected void validateOperationSpecific() {
        if (this.sqlQuery == null || this.sqlQuery.isEmpty()) {
            throw new IllegalStateException("SQL query is required for SQL_PREDICT operation");
        }
        MlSqlJobParameters.validateLimit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "MlSqlJobParameters{modelId='" + this.id() + "', modelName='" + this.name() + "', version='" + this.version() + "', type=" + this.type() + ", url='" + this.url() + "', operationType=" + this.operationType() + ", sqlQuery='" + this.sqlQuery + "', sqlParamsCount=" + (this.sqlParams != null ? this.sqlParams.length : 0) + ", limit=" + this.limit + ", hasCustomComponents=" + this.hasCustomComponents() + (String)(this.customJobClass() != null ? ", customJobClass=" + this.customJobClass().getName() : "") + (String)(this.customInputMarshaller() != null ? ", customInputMarshaller=" + this.customInputMarshaller().getClass().getName() : "") + (String)(this.customOutputMarshaller() != null ? ", customOutputMarshaller=" + this.customOutputMarshaller().getClass().getName() : "") + "}";
    }

    public static class Builder
    extends MlJobParameters.Builder {
        private String sqlQuery;
        private Serializable[] sqlParams;
        private int limit = 1000;
        private String inputColumn;

        public Builder() {
            this.operationType = MlJobParameters.OperationType.SQL_PREDICT;
        }

        public Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public Builder sqlParams(Serializable[] sqlParams) {
            this.sqlParams = sqlParams;
            return this;
        }

        public Builder inputColumn(String inputColumn) {
            this.inputColumn = inputColumn;
            return this;
        }

        public Builder limit(int limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("limit must be at least 1, got: " + limit);
            }
            if (limit > 5000) {
                throw new IllegalArgumentException("limit cannot exceed 5000, got: " + limit);
            }
            this.limit = limit;
            return this;
        }

        @Override
        public Builder id(String id) {
            super.id(id);
            return this;
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder version(String version) {
            super.version(version);
            return this;
        }

        @Override
        public Builder url(String url) {
            super.url(url);
            return this;
        }

        @Override
        public Builder config(ModelConfig config) {
            super.config(config);
            return this;
        }

        @Override
        public Builder addProperty(String key, String value) {
            super.addProperty(key, value);
            return this;
        }

        @Override
        public Builder property(String key, String value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder properties(Map<String, String> properties) {
            super.properties((Map)properties);
            return this;
        }

        @Override
        public Builder loaded(boolean loaded) {
            super.loaded(loaded);
            return this;
        }

        @Override
        public Builder loadTimestamp(long loadTimestamp) {
            super.loadTimestamp(loadTimestamp);
            return this;
        }

        @Override
        public Builder status(ModelInfo.ModelStatus status) {
            super.status(status);
            return this;
        }

        @Override
        public Builder from(ModelInfo modelInfo) {
            super.from(modelInfo);
            return this;
        }

        @Override
        public Builder operationType(MlJobParameters.OperationType operationType) {
            super.operationType(operationType);
            return this;
        }

        @Override
        public Builder customJobClass(Class customJobClass) {
            super.customJobClass(customJobClass);
            return this;
        }

        @Override
        public Builder customInputMarshaller(Marshaller<?, byte[]> customInputMarshaller) {
            super.customInputMarshaller(customInputMarshaller);
            return this;
        }

        @Override
        public Builder customOutputMarshaller(Marshaller<?, byte[]> customOutputMarshaller) {
            super.customOutputMarshaller(customOutputMarshaller);
            return this;
        }

        @Override
        public Builder inputClass(String inputClass) {
            super.inputClass(inputClass);
            return this;
        }

        @Override
        public Builder outputClass(String outputClass) {
            super.outputClass(outputClass);
            return this;
        }

        @Override
        public Builder translator(String translator) {
            super.translator(translator);
            return this;
        }

        @Override
        public Builder translatorFactory(String translatorFactory) {
            super.translatorFactory(translatorFactory);
            return this;
        }

        @Override
        public MlSqlJobParameters build() {
            MlSqlJobParameters params = new MlSqlJobParameters(this);
            params.validate();
            params.inputColumn = this.inputColumn;
            return params;
        }
    }
}

