/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.upgrade;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.ClusterStateV2;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.configuration.ConfigurationRegistry;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.version.IgniteProductVersionSource;
import org.gridgain.internal.lock.OperationLock;
import org.gridgain.internal.upgrade.RollingUpgradeManager;
import org.gridgain.internal.upgrade.UpgradeState;
import org.gridgain.internal.upgrade.exception.UpgradeCancelException;
import org.gridgain.internal.upgrade.exception.UpgradeCommitException;
import org.gridgain.internal.upgrade.exception.VersionFormatException;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeMessaging;
import org.jetbrains.annotations.Nullable;

public class RollingUpgradeManagerImpl
implements RollingUpgradeManager {
    private static final IgniteLogger LOG = Loggers.forClass(RollingUpgradeManagerImpl.class);
    private final RollingUpgradeMessaging messaging;
    private final ClusterManagementGroupManager cmgManager;
    private final ConfigurationRegistry clusterConfiguration;
    private final MetaStorageManager metaStorageMgr;
    private final TopologyService topologyService;

    public RollingUpgradeManagerImpl(MessagingService messagingService, TopologyService topologyService, ClusterManagementGroupManager cmgManager, MetaStorageManager metaStorageMgr, IgniteProductVersionSource versionProvider, ConfigurationRegistry clusterConfiguration) {
        this.metaStorageMgr = metaStorageMgr;
        this.topologyService = topologyService;
        this.cmgManager = cmgManager;
        this.clusterConfiguration = clusterConfiguration;
        this.messaging = new RollingUpgradeMessaging(messagingService, topologyService, versionProvider);
    }

    @Override
    public CompletableFuture<Boolean> startUpgrade(String version) {
        LOG.info("Starting rolling upgrade to version: " + version, new Object[0]);
        try {
            IgniteProductVersion.fromString(version);
        }
        catch (IllegalArgumentException ex) {
            throw new VersionFormatException(ex);
        }
        return ((CompletableFuture)OperationLock.ROLLING_UPGRADE.start(this.metaStorageMgr).thenCompose(unused -> this.cmgManager.rollingUpgradeVersion(version))).thenApply(unused -> true);
    }

    @Override
    public CompletableFuture<Boolean> commitUpgrade() {
        LOG.info("Committing rolling upgrade", new Object[0]);
        return ((CompletableFuture)this.cmgManager.logicalTopology().thenCombine(this.cmgManager.clusterState(), (logicalTopologySnapshot, state) -> {
            if (state instanceof ClusterStateV2) {
                Set physicalNodeNames;
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    LOG.error("No rolling upgrade in progress to commit.", new Object[0]);
                    throw new UpgradeCommitException("No rolling upgrade in progress to commit.");
                }
                Map<String, String> notUpgradedNodes = logicalTopologySnapshot.nodes().stream().filter(node -> !RollingUpgradeManagerImpl.isNodeVersion(stateV2.nextVersion(), node)).collect(Collectors.toMap(ClusterNodeImpl::name, node -> node.systemAttributes().get("ignite.version")));
                if (!notUpgradedNodes.isEmpty()) {
                    LOG.error("The following nodes {} have not been upgraded to the target version {}.", notUpgradedNodes, stateV2.nextVersion());
                    throw new UpgradeCommitException(String.format("Cannot commit rolling upgrade. The following nodes have not been upgraded to the target version %s: %s", stateV2.nextVersion(), notUpgradedNodes));
                }
                Set logicalNodeNames = logicalTopologySnapshot.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
                if (!logicalNodeNames.containsAll(physicalNodeNames = this.topologyService.allMembers().stream().map(InternalClusterNode::name).collect(Collectors.toSet()))) {
                    LOG.error("Logical topology nodes {} do not contain all physical topology nodes {}.", logicalNodeNames, physicalNodeNames);
                    throw new UpgradeCommitException("Cannot commit rolling upgrade. Logical topology nodes " + logicalNodeNames + " do not contain all physical topology nodes " + physicalNodeNames + ".");
                }
            } else {
                throw new UpgradeCommitException(String.format("Cannot commit rolling upgrade. Cluster has unsupported nodes %s", logicalTopologySnapshot.nodes()));
            }
            return true;
        })).thenCompose(validation -> {
            LOG.info("All nodes have been upgraded to the target version. Proceeding with commit.", new Object[0]);
            return ((CompletableFuture)this.cmgManager.rollingUpgradeCommit().whenComplete((unused, ex) -> OperationLock.ROLLING_UPGRADE.stop(this.metaStorageMgr))).thenApply(unused -> true);
        });
    }

    @Override
    public CompletableFuture<Boolean> cancelUpgrade() {
        LOG.info("Canceling rolling upgrade", new Object[0]);
        return ((CompletableFuture)this.cmgManager.logicalTopology().thenCombine(this.cmgManager.clusterState(), (logicalTopologySnapshot, state) -> {
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    LOG.error("No rolling upgrade in progress to cancel.", new Object[0]);
                    throw new UpgradeCancelException("No rolling upgrade in progress to cancel.");
                }
                Set upgradedNodes = logicalTopologySnapshot.nodes().stream().filter(node -> !RollingUpgradeManagerImpl.isNodeVersion(stateV2.version(), node)).map(ClusterNodeImpl::name).collect(Collectors.toSet());
                if (!upgradedNodes.isEmpty()) {
                    LOG.error("The following nodes {} have not been downgraded to the current version {}.", upgradedNodes, stateV2.version());
                    throw new UpgradeCancelException("Cannot cancel rolling upgrade. The following nodes have not been downgraded to the current version " + stateV2.version() + ": " + upgradedNodes);
                }
            } else {
                throw new UpgradeCancelException(String.format("Cannot cancel rolling upgrade. Cluster has unsupported nodes %s", logicalTopologySnapshot.nodes()));
            }
            return true;
        })).thenCompose(validation -> {
            LOG.info("All nodes have been downgraded to the current version. Proceeding with cancel.", new Object[0]);
            return ((CompletableFuture)this.cmgManager.rollingUpgradeCancel().whenComplete((unused, ex) -> OperationLock.ROLLING_UPGRADE.stop(this.metaStorageMgr))).thenApply(unused -> true);
        });
    }

    @Override
    public CompletableFuture<Boolean> isUpgradeInProgress() {
        return this.cmgManager.clusterState().thenApply(state -> {
            if (state instanceof ClusterStateV2) {
                return ((ClusterStateV2)state).nextVersion() != null;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> blockConfigurationUpdatesIfNeeded() {
        return this.isUpgradeInProgress().thenApply(upgradeInProgress -> {
            if (upgradeInProgress.booleanValue()) {
                LOG.info("Rolling upgrade in progress, blocking cluster configuration updates", new Object[0]);
                this.clusterConfiguration.blockUpdates();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> isNodeUpgraded(String nodeId) {
        return this.cmgManager.clusterState().thenCompose(state -> {
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    return CompletableFutures.falseCompletedFuture();
                }
                return this.messaging.nodeVersion(nodeId).thenApply(version -> version.equals(stateV2.nextVersion()));
            }
            return CompletableFutures.falseCompletedFuture();
        });
    }

    @Override
    public CompletableFuture<Boolean> isTargetVersion(String version) {
        return this.cmgManager.clusterState().thenApply(state -> {
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    return true;
                }
                return stateV2.nextVersion().equals(version);
            }
            return true;
        });
    }

    @Override
    public CompletableFuture<UpgradeState> upgradeState() {
        return this.cmgManager.logicalTopology().thenCombine(this.cmgManager.clusterState(), (logicalTopologySnapshot, state) -> {
            Set<String> currentVersionNodes = RollingUpgradeManagerImpl.versionNodes(logicalTopologySnapshot, state.version());
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                Set<String> nextVersionNodes = RollingUpgradeManagerImpl.versionNodes(logicalTopologySnapshot, stateV2.nextVersion());
                return new UpgradeState(stateV2.version(), stateV2.nextVersion(), currentVersionNodes, nextVersionNodes);
            }
            return new UpgradeState(state.version(), null, currentVersionNodes, Set.of());
        });
    }

    private static Set<String> versionNodes(LogicalTopologySnapshot logicalTopology, @Nullable String version) {
        return logicalTopology.nodes().stream().filter(node -> RollingUpgradeManagerImpl.isNodeVersion(version, node)).map(ClusterNodeImpl::name).collect(Collectors.toSet());
    }

    private static boolean isNodeVersion(@Nullable String version, LogicalNode node) {
        String nodeVersion = node.systemAttributes().get("ignite.version");
        return nodeVersion != null && nodeVersion.equals(version);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return ((CompletableFuture)this.isUpgradeInProgress().thenAccept(upgradeInProgress -> {
            if (!upgradeInProgress.booleanValue()) {
                this.clusterConfiguration.unblockUpdates();
            }
        })).thenRun(this.messaging::start);
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

