/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.s3;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.gridgain.internal.sql.copy.parquet.s3.S3InputFile;
import org.gridgain.internal.sql.copy.parquet.s3.S3OutputFile;
import org.gridgain.internal.sql.copy.s3.S3InputStream;
import org.gridgain.internal.sql.copy.s3.S3OutputStream;
import org.gridgain.internal.sql.copy.s3.S3Uri;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3ClientFactory {
    public static Reader getInputStreamReader(String path, Map<String, String> properties) {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        S3InputStream s3InputStream = new S3InputStream(s3Client, new S3Uri(path));
        return new InputStreamReader((InputStream)((Object)s3InputStream));
    }

    public static Writer getOutputStreamWriter(String path, Map<String, String> properties) throws IOException {
        S3Uri uri;
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        if (S3ClientFactory.keyExist(s3Client, uri = new S3Uri(path))) {
            throw new IOException("Key already exists: " + path);
        }
        S3OutputStream s3OutputStream = new S3OutputStream(s3Client, uri);
        return new OutputStreamWriter((OutputStream)((Object)s3OutputStream));
    }

    public static InputFile getS3InputFile(String path, Map<String, String> properties) {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        return S3InputFile.fromLocation(path, s3Client);
    }

    public static OutputFile getS3OutputFile(String path, Map<String, String> properties) throws IOException {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        if (S3ClientFactory.keyExist(s3Client, new S3Uri(path))) {
            throw new IOException("Key already exists: " + path);
        }
        return S3OutputFile.fromLocation(path, s3Client);
    }

    public static S3Client createS3Client(Map<String, String> properties) {
        Optional<String> uri = Optional.ofNullable(properties.get("s3.endpoint"));
        S3ClientBuilder builder = S3Client.builder();
        if (uri.isPresent()) {
            builder = (S3ClientBuilder)builder.endpointOverride(URI.create(uri.get()));
        }
        Optional<String> accessKeyId = Optional.ofNullable(properties.get("s3.access-key-id"));
        Optional<String> secretAccessKey = Optional.ofNullable(properties.get("s3.secret-access-key"));
        Object credentialsProvider = accessKeyId.isPresent() && secretAccessKey.isPresent() ? StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId.get(), (String)secretAccessKey.get())) : DefaultCredentialsProvider.builder().build();
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)builder.region(Region.of((String)properties.get("s3.client-region")))).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build();
    }

    public static boolean keyExist(S3Client client, S3Uri uri) {
        try {
            HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(uri.bucket()).key(uri.key());
            return client.headObject((HeadObjectRequest)requestBuilder.build()) != null;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }
}

