/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class PathUtils {
    public static List<Path> getFilesByPattern(String root, final String pattern) throws IOException {
        final ArrayList<Path> matchedFiles = new ArrayList<Path>();
        Files.walkFileTree(Paths.get(root, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().matches(pattern)) {
                    matchedFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return matchedFiles;
    }
}

