/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.signature;

import java.io.IOException;
import java.util.Base64;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.snapshots.signature.SnapshotSignature;

public class SnapshotSignatureSerializer {
    private final EncryptionManager encryptionManager;

    public SnapshotSignatureSerializer(EncryptionManager encryptionManager) {
        this.encryptionManager = encryptionManager;
    }

    public SnapshotSignature readSignature(String signature, String providerName) {
        byte[] decode = Base64.getDecoder().decode(signature);
        return VersionedSerialization.fromBytes(decode, new SnapshotSignatureVersionSerializer(this.encryptionManager, providerName));
    }

    public String serializeSnapshotSignature(SnapshotSignature signature, String providerName) {
        byte[] arr = VersionedSerialization.toBytes(signature, new SnapshotSignatureVersionSerializer(this.encryptionManager, providerName));
        return Base64.getEncoder().encodeToString(arr);
    }

    private static class SnapshotSignatureVersionSerializer
    extends VersionedSerializer<SnapshotSignature> {
        private final EncryptionManager encryptionManager;
        private final String providerName;

        private SnapshotSignatureVersionSerializer(EncryptionManager encryptionManager, String providerName) {
            this.encryptionManager = encryptionManager;
            this.providerName = providerName;
        }

        @Override
        protected void writeExternalData(SnapshotSignature signature, IgniteDataOutput out) throws IOException {
            SnapshotSignatureVersionSerializer.writeNullableString(signature.cipherAlgorithm(), out);
            SnapshotSignatureVersionSerializer.writeByteArrayWithLength(this.encryptionManager.encryptDataKeyByProvider(signature.key(), this.providerName), out);
        }

        @Override
        protected SnapshotSignature readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
            String cipherAlgorithm = SnapshotSignatureVersionSerializer.readNullableString(in);
            byte[] bytes = SnapshotSignatureVersionSerializer.readByteArrayWithLength(in);
            return new SnapshotSignature(this.encryptionManager.decryptDataKey(bytes), cipherAlgorithm);
        }
    }
}

