/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.encryption.DataEncryptionKeyManager;
import org.gridgain.internal.encryption.DataEncryptionKeyNotFoundException;
import org.gridgain.internal.encryption.DataKeyGenerator;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotIllegalArgumentException;
import org.gridgain.internal.snapshots.SnapshotMetaNotFoundException;
import org.gridgain.internal.snapshots.SnapshotMetaSerializer;
import org.gridgain.internal.snapshots.SnapshotUriNotFoundException;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;
import org.gridgain.internal.snapshots.configuration.ClusterSnapshotConfiguration;
import org.gridgain.internal.snapshots.configuration.SnapshotUriView;
import org.gridgain.internal.snapshots.filesystem.EncryptedSnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.LocalSnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.LocalSnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.filesystem.SnapshotMetaPath;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;
import org.gridgain.internal.snapshots.filesystem.SnapshotUriWithName;
import org.gridgain.internal.snapshots.meta.SnapshotEncryptionMeta;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.signature.SnapshotSignature;
import org.gridgain.internal.snapshots.signature.SnapshotSignatureSerializer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SnapshotFileSystemManagerImpl
implements SnapshotFileSystemManager {
    private static final String SNAPSHOT_FOLDER_PREFIX = "snapshot-";
    private static final String FILE_SCHEMA = "file";
    public static final SnapshotUriWithName DEFAULT_SNAPSHOT_URI = new SnapshotUriWithName(URI.create("snapshots"), SnapshotUri.PathType.LOCAL, "<default_non_configurable>");
    private final Path nodeWorkDir;
    private final ClusterSnapshotConfiguration clusterSnapshotConfiguration;
    private final ConfigurationListener<NamedListView<SnapshotUriView>> updatePathsListener;
    private final String nodeName;
    private volatile SnapshotUriWithName defaultSnapshotUri;
    private final Map<String, SnapshotUriWithName> pathByName = new ConcurrentHashMap<String, SnapshotUriWithName>();
    private final SnapshotMetaSerializer snapshotMetaSerializer;
    private final SnapshotSignatureSerializer snapshotSignatureSerializer;
    private final Object snapshotPathsMutex = new Object();
    private final DataEncryptionKeyManager dataEncryptionKeyManager;
    private final ByteBufferPoolProvider bufferPoolProvider;

    public SnapshotFileSystemManagerImpl(ClusterSnapshotConfiguration clusterSnapshotConfiguration, Path nodeWorkDir, String nodeName, EncryptionManager encryptionManager, DataEncryptionKeyManager dataEncryptionKeyManager, ByteBufferPoolProvider bufferPoolProvider) {
        this.clusterSnapshotConfiguration = clusterSnapshotConfiguration;
        this.nodeName = nodeName;
        this.nodeWorkDir = nodeWorkDir;
        this.snapshotMetaSerializer = new SnapshotMetaSerializer();
        this.snapshotSignatureSerializer = new SnapshotSignatureSerializer(encryptionManager);
        this.dataEncryptionKeyManager = dataEncryptionKeyManager;
        this.bufferPoolProvider = bufferPoolProvider;
        this.updatePathsListener = event -> this.updatePaths((NamedListView)event.newValue());
    }

    @TestOnly
    public Path defaultSnapshotsPath() {
        return this.basePath(this.defaultSnapshotUri);
    }

    @Override
    public SnapshotFileSystem snapshotFileSystem(UUID snapshotId) {
        return this.snapshotFileSystem(snapshotId, this.snapshotUri(null));
    }

    @Override
    public SnapshotFileSystem snapshotFileSystem(UUID snapshotId, SnapshotUri snapshotUri) {
        SnapshotFileSystemManagerImpl.checkSchema(snapshotUri);
        Path basePath = this.basePath(snapshotUri);
        LocalSnapshotFileSystem localSnapshotFileSystem = new LocalSnapshotFileSystem(snapshotId, basePath.resolve(SNAPSHOT_FOLDER_PREFIX + snapshotId), this.bufferPoolProvider);
        SnapshotSignature signature = this.findSnapshotSignature(snapshotId, localSnapshotFileSystem);
        if (signature != null) {
            return new EncryptedSnapshotFileSystem(localSnapshotFileSystem, new SnapshotEncryptor(signature.key(), signature.cipherAlgorithm()), this.bufferPoolProvider);
        }
        return localSnapshotFileSystem;
    }

    @Nullable
    private SnapshotSignature findSnapshotSignature(UUID snapshotId, SnapshotFileSystem snapshotFileSystem) {
        try {
            SnapshotMeta snapshotMeta = this.snapshotMetaSerializer.readSnapshotMeta(snapshotFileSystem);
            SnapshotEncryptionMeta encryption = snapshotMeta.encryption();
            return encryption != null ? this.snapshotSignatureSerializer.readSignature(encryption.signature(), encryption.providerName()) : null;
        }
        catch (SnapshotMetaNotFoundException e1) {
            try {
                DataEncryptionKey dataEncryptionKey = this.dataEncryptionKeyManager.activeKey(snapshotId.toString());
                return new SnapshotSignature(dataEncryptionKey, DataKeyGenerator.defaultCipherAlgorithm());
            }
            catch (DataEncryptionKeyNotFoundException e) {
                return null;
            }
        }
    }

    private Path basePath(SnapshotUri snapshotUri) {
        URI uri = snapshotUri.uri();
        if (!uri.isAbsolute()) {
            return this.nodeWorkDir.resolve(uri.getPath());
        }
        Path basePath = Path.of(uri);
        return snapshotUri.isSingleCopy() ? basePath : basePath.resolve(this.nodeName);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext context) {
        this.clusterSnapshotConfiguration.paths().listen(this.updatePathsListener);
        return this.updatePaths((NamedListView)this.clusterSnapshotConfiguration.paths().value());
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext context) {
        this.clusterSnapshotConfiguration.paths().stopListen(this.updatePathsListener);
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotUriWithName snapshotUri(@Nullable String name) {
        Object object = this.snapshotPathsMutex;
        synchronized (object) {
            if (name == null) {
                return this.defaultSnapshotUri;
            }
            SnapshotUriWithName snapshotUri = this.pathByName.get(name);
            if (snapshotUri == null) {
                throw new SnapshotUriNotFoundException(name);
            }
            return snapshotUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SnapshotUriWithName> snapshotUris() {
        Object object = this.snapshotPathsMutex;
        synchronized (object) {
            int size = this.defaultSnapshotUri == null ? this.pathByName.size() + 1 : this.pathByName.size();
            ArrayList<SnapshotUriWithName> res = new ArrayList<SnapshotUriWithName>(size);
            res.addAll(this.pathByName.values());
            if (this.defaultSnapshotUri == null) {
                res.add(DEFAULT_SNAPSHOT_URI);
            }
            return res;
        }
    }

    @Override
    public List<SnapshotMetaPath> scanSnapshotMeta(SnapshotUri uri) {
        List<SnapshotMetaPath> list;
        block9: {
            SnapshotFileSystemManagerImpl.checkSchema(uri);
            Path basePath = this.basePath(uri);
            if (!Files.exists(basePath, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> stream = Files.list(basePath);
            try {
                list = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(SNAPSHOT_FOLDER_PREFIX)).map(path -> new LocalSnapshotMetaPath(path.resolve("meta.json"))).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SnapshotException(String.format("Error when listing snapshots in path: [uri=%s]", uri.uri()), (Throwable)e);
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    public SnapshotMeta readSnapshotMeta(SnapshotMetaPath path) {
        return SnapshotMetaSerializer.readSnapshotMeta(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> updatePaths(@Nullable NamedListView<SnapshotUriView> paths) {
        Object object = this.snapshotPathsMutex;
        synchronized (object) {
            this.pathByName.clear();
            this.defaultSnapshotUri = null;
            if (paths != null) {
                paths.forEach(uriView -> {
                    String name = uriView.name();
                    SnapshotUriWithName snapshotUri = new SnapshotUriWithName(URI.create(uriView.uri()), SnapshotUri.PathType.valueOf(uriView.type()), name);
                    if (uriView.isDefault()) {
                        this.defaultSnapshotUri = snapshotUri;
                    }
                    this.pathByName.put(name, snapshotUri);
                });
            }
            if (this.defaultSnapshotUri == null) {
                this.defaultSnapshotUri = DEFAULT_SNAPSHOT_URI;
            }
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private static void checkSchema(SnapshotUri snapshotUri) {
        URI uri = snapshotUri.uri();
        if (uri.getScheme() != null && !FILE_SCHEMA.equals(uri.getScheme())) {
            throw new SnapshotIllegalArgumentException(String.format("Unsupported URI scheme: [uri=%s, schema=%s]", uri, uri.getScheme()));
        }
    }
}

