/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.catalog;

import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommand;
import org.apache.ignite3.internal.catalog.commands.RenameTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.storage.RenameIndexEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.IndexDescriptorView;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;

public class RenameTemporaryTablesCommand
implements CatalogCommand {
    private final String tmpTableNamePrefix;
    private final SnapshotMeta snapshotMeta;

    public RenameTemporaryTablesCommand(String tmpTableNamePrefix, SnapshotMeta snapshotMeta) {
        this.tmpTableNamePrefix = tmpTableNamePrefix;
        this.snapshotMeta = snapshotMeta;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CommandState commandState = new CommandState(catalog);
        for (TableSnapshotMeta tableSnapshotMeta : this.snapshotMeta.tableSnapshotMetas()) {
            TableDescriptorView tableView = tableSnapshotMeta.schema().tableDescriptor();
            String originalTableName = tableView.name();
            String tmpTableName = this.tmpTableNamePrefix + originalTableName;
            CatalogCommand renameTableCommand = ((RenameTableCommandBuilder)((RenameTableCommandBuilder)RenameTableCommand.builder().schemaName(tableView.schemaName())).tableName(tmpTableName)).newTableName(originalTableName).validateSystemSchemas(false).build();
            commandState.applyCommand(renameTableCommand);
            CatalogSchemaDescriptor schemaDescriptor = catalog.schema(tableView.schemaName());
            assert (schemaDescriptor != null) : "Schema " + tableView.schemaName() + " not found";
            for (IndexDescriptorView indexView : tableSnapshotMeta.schema().secondaryIndexDescriptors()) {
                String newIndexName = indexView.name();
                CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schemaDescriptor, newIndexName);
                CatalogIndexDescriptor tmpIndexDescriptor = CatalogUtils.index(schemaDescriptor, this.tmpTableNamePrefix + newIndexName, true);
                RenameIndexEntry renameEntry = new RenameIndexEntry(tmpIndexDescriptor.id(), newIndexName);
                commandState.applyCommand(List.of(renameEntry));
            }
        }
        return commandState.updateEntries();
    }
}

