/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.utils.EncryptionUtils;

public class SnapshotEncryptor {
    public static final ByteOrder ENCRYPTION_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private final Random random = new SecureRandom();
    private final DataEncryptionKey key;
    private final ThreadLocal<Cipher> cipher;

    public SnapshotEncryptor(DataEncryptionKey dataEncryptionKey, String cipherAlgorithm) {
        this.key = dataEncryptionKey;
        this.cipher = ThreadLocal.withInitial(() -> {
            try {
                return Cipher.getInstance(cipherAlgorithm);
            }
            catch (GeneralSecurityException e) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
        });
    }

    public Cipher cipher() {
        return this.cipher.get();
    }

    public void encrypt(ByteBuffer srcBuffer, ByteBuffer targetBuffer) {
        Cipher cipher = this.cipher();
        SnapshotEncryptor.checkSrcBufferCapacity(srcBuffer, cipher);
        assert (srcBuffer.position() == 0);
        int prevLimit = srcBuffer.limit();
        srcBuffer.limit(srcBuffer.capacity());
        targetBuffer.putInt(prevLimit);
        EncryptionUtils.encrypt(cipher, this.random, srcBuffer, targetBuffer, this.key.key());
        srcBuffer.limit(prevLimit);
        srcBuffer.position(prevLimit);
    }

    public void decrypt(ByteBuffer srcBuffer, ByteBuffer targetBuffer) {
        assert (srcBuffer.order() == ENCRYPTION_BYTE_ORDER);
        int payloadSize = srcBuffer.getInt();
        int startPosition = targetBuffer.position();
        EncryptionUtils.decrypt(this.cipher(), srcBuffer, targetBuffer, this.key.key());
        targetBuffer.position(startPosition + payloadSize);
        targetBuffer.limit(startPosition + payloadSize);
    }

    private static void checkSrcBufferCapacity(ByteBuffer srcBuffer, Cipher cipher) {
        String algorithm = cipher.getAlgorithm();
        if (algorithm.startsWith("AES")) {
            if (srcBuffer.capacity() % 16 != 0) {
                throw new IllegalArgumentException("AES cipher requires the input buffer's capacity to be a multiple of 16: " + srcBuffer.capacity());
            }
        } else {
            throw new IllegalArgumentException("Unsupported cipher: " + algorithm);
        }
    }

    public static int computeTargetEncryptedBufferSize(Cipher cipher, int srcBufferSize) {
        return SnapshotEncryptor.computeTargetEncryptedBufferSize(cipher.getBlockSize(), srcBufferSize);
    }

    public static int computeTargetEncryptedBufferSize(Integer blockSize, int srcBufferSize) {
        return 4 + blockSize + srcBufferSize;
    }
}

