/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Checksum;
import org.gridgain.internal.snapshots.RowSnapshotWriter;

public class ChecksumChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final Checksum checksum;

    public ChecksumChannel(WritableByteChannel channel, Checksum checksum) {
        this.delegate = channel;
        this.checksum = checksum;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checksum.update(src);
        src.rewind();
        return this.delegate.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.delegate.isOpen()) {
                this.delegate.write(ByteBuffer.allocate(16).order(RowSnapshotWriter.BYTE_ORDER).putLong(this.checksum.getValue()).flip());
            }
        }
        finally {
            this.delegate.close();
        }
    }
}

