/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.zip.CRC32C;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.BinaryRowAndRowId;
import org.apache.ignite3.internal.storage.RowId;
import org.gridgain.internal.snapshots.SnapshotException;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotFileReader
implements Iterable<BinaryRowAndRowId>,
AutoCloseable {
    private static final int CHECKSUM_BYTES = 8;
    private final int tableVersion;
    private final int partitionId;
    private final ReadableByteChannel channel;
    private final URI uri;
    private final int numColumns;
    private final int chunkSize;

    PartitionSnapshotFileReader(URI pathUri, ReadableByteChannel channel, int tableVersion, int partitionId, int numColumns, int chunkSize) {
        this.tableVersion = tableVersion;
        this.uri = pathUri;
        this.partitionId = partitionId;
        this.channel = channel;
        this.numColumns = numColumns;
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<BinaryRowAndRowId> iterator() {
        return new BinaryRowAndRowIdIterator();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private class BinaryRowAndRowIdIterator
    implements Iterator<BinaryRowAndRowId> {
        private final CRC32C checksum = new CRC32C();
        private ByteBuffer rowIdBuffer;
        private final ByteBuffer buffer;
        @Nullable
        private BinaryRowAndRowId next;

        private BinaryRowAndRowIdIterator() {
            this.buffer = ByteBuffer.allocate(PartitionSnapshotFileReader.this.chunkSize).flip();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.buffer.remaining() == 0) {
                this.readNextBatch(true);
            }
            if (!this.tryFillRowIdBuffer()) {
                return false;
            }
            this.checksum.update(this.rowIdBuffer);
            this.rowIdBuffer.rewind();
            RowId rowId = new RowId(PartitionSnapshotFileReader.this.partitionId, new UUID(this.rowIdBuffer.getLong(), this.rowIdBuffer.getLong()));
            if (this.buffer.remaining() == 0) {
                this.readNextBatch(true);
            }
            byte flags = this.buffer.get();
            this.checksum.update(flags);
            this.next = flags == 24 ? new BinaryRowAndRowId(null, rowId) : this.readBinaryRowAndRowId(flags, rowId);
            return true;
        }

        private boolean tryFillRowIdBuffer() {
            if (this.rowIdBuffer == null) {
                this.rowIdBuffer = this.allocateBuffer(16);
            } else {
                this.rowIdBuffer.clear();
            }
            this.fillBuffer(this.rowIdBuffer, false);
            if (this.rowIdBuffer.remaining() > 0) {
                if (this.rowIdBuffer.position() == 8) {
                    this.validateChecksum(this.rowIdBuffer);
                    return false;
                }
                throw this.parseException("Unexpected EOF", null);
            }
            this.rowIdBuffer.rewind();
            return true;
        }

        @Override
        public BinaryRowAndRowId next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BinaryRowAndRowId current = this.next;
            this.next = null;
            return current;
        }

        private BinaryRowAndRowId readBinaryRowAndRowId(byte flags, RowId rowId) {
            int varSizeBits = flags & 3;
            int offsetTableEntrySize = 1 << varSizeBits;
            ByteBuffer offsetTable = this.readOffsetTable(offsetTableEntrySize);
            int valueBufferSize = this.getTupleEnd(offsetTable, offsetTableEntrySize);
            ByteBuffer tupleBuffer = this.allocateBuffer(1 + offsetTable.remaining() + valueBufferSize).put(flags).put(offsetTable);
            this.fillBuffer(tupleBuffer, true);
            tupleBuffer.rewind();
            this.checksum.update(tupleBuffer.position(1));
            tupleBuffer.rewind();
            return new BinaryRowAndRowId(new BinaryRowImpl(PartitionSnapshotFileReader.this.tableVersion, tupleBuffer), rowId);
        }

        private boolean readNextBatch(boolean strict) {
            try {
                this.buffer.clear();
                int bytesRead = 0;
                while (this.buffer.remaining() > 0 && bytesRead >= 0) {
                    bytesRead = PartitionSnapshotFileReader.this.channel.read(this.buffer);
                }
                this.buffer.flip();
                if (this.buffer.remaining() == 0 && strict) {
                    throw this.parseException("Unexpected EOF", null);
                }
                return this.buffer.remaining() != 0;
            }
            catch (IOException e) {
                throw this.parseException("IO error", e);
            }
        }

        private ByteBuffer readOffsetTable(int offsetTableEntrySize) {
            ByteBuffer offsetTable = this.allocateBuffer(offsetTableEntrySize * PartitionSnapshotFileReader.this.numColumns);
            this.fillBuffer(offsetTable, true);
            offsetTable.rewind();
            return offsetTable;
        }

        private void fillBuffer(ByteBuffer dst, boolean strict) {
            int bytesToRead = dst.remaining();
            if (this.buffer.remaining() >= bytesToRead) {
                int oldLimit = this.buffer.limit();
                this.buffer.limit(this.buffer.position() + bytesToRead);
                dst.put(this.buffer);
                this.buffer.limit(oldLimit);
            } else {
                if (this.buffer.remaining() > 0) {
                    dst.put(this.buffer);
                }
                if (!this.readNextBatch(strict)) {
                    return;
                }
                this.fillBuffer(dst, strict);
            }
        }

        private int getTupleEnd(ByteBuffer offsetTable, int entrySize) {
            int lastElementIndex = offsetTable.limit() - entrySize;
            switch (entrySize) {
                case 1: {
                    return Byte.toUnsignedInt(offsetTable.get(lastElementIndex));
                }
                case 2: {
                    return Short.toUnsignedInt(offsetTable.getShort(lastElementIndex));
                }
                case 4: {
                    int offset = offsetTable.getInt(lastElementIndex);
                    assert (offset > 0);
                    return offset;
                }
            }
            throw this.parseException("Invalid offset table size: " + entrySize, null);
        }

        private void validateChecksum(ByteBuffer buffer) {
            buffer.rewind();
            long expectedChecksum = buffer.getLong();
            if (this.checksum.getValue() != expectedChecksum) {
                throw this.parseException("checksums don't match", null);
            }
        }

        private SnapshotException parseException(String message, @Nullable Throwable cause) {
            return new SnapshotException(String.format("Snapshot file %s is malformed: %s.", PartitionSnapshotFileReader.this.uri, message), cause);
        }

        private ByteBuffer allocateBuffer(int capacity) {
            return ByteBuffer.allocate(capacity).order(BinaryTuple.ORDER);
        }
    }
}

