/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store;

import java.util.Objects;
import org.gridgain.internal.security.key.store.PublicKeyRecord;
import org.jetbrains.annotations.Nullable;

public class PublicKeyChainRecord {
    private final PublicKeyRecord keyRecord;
    @Nullable
    private final PublicKeyRecord prevKeyRecord;

    public PublicKeyChainRecord(PublicKeyRecord keyRecord, @Nullable PublicKeyRecord prevKeyRecord) {
        this.keyRecord = keyRecord;
        this.prevKeyRecord = prevKeyRecord;
    }

    public PublicKeyChainRecord merge(PublicKeyRecord newKeyRecord) {
        if (newKeyRecord.equals(this.keyRecord)) {
            return this;
        }
        if (newKeyRecord.metadata().issuedAt().isAfter(this.keyRecord.metadata().issuedAt())) {
            return new PublicKeyChainRecord(newKeyRecord, this.keyRecord);
        }
        throw new IllegalStateException("The new key is older than the current one.");
    }

    public PublicKeyRecord keyRecord() {
        return this.keyRecord;
    }

    @Nullable
    public PublicKeyRecord prevKeyRecord() {
        return this.prevKeyRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyChainRecord that = (PublicKeyChainRecord)o;
        return Objects.equals(this.keyRecord, that.keyRecord) && Objects.equals(this.prevKeyRecord, that.prevKeyRecord);
    }

    public int hashCode() {
        return Objects.hash(this.keyRecord, this.prevKeyRecord);
    }
}

