/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.gridgain.internal.security.key.IgniteKeyPair;
import org.gridgain.internal.security.key.KeyMetadata;
import org.gridgain.internal.security.key.SecretGenerator;

public class RsaSecretGenerator
implements SecretGenerator<RSAPrivateKey, RSAPublicKey> {
    private static final int KEY_SIZE = 2048;

    @Override
    public IgniteKeyPair<RSAPrivateKey, RSAPublicKey> generateKeyPair(int id, long ttl) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair keyPair = keyGen.generateKeyPair();
            Instant issuedAt = Instant.now();
            return new IgniteKeyPair<RSAPrivateKey, RSAPublicKey>((RSAPrivateKey)keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic(), new KeyMetadata(id, issuedAt, issuedAt.plusMillis(ttl)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }
}

