/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.rbac.configuration;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite3.internal.configuration.presentation.HoconPresentation;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.jetbrains.annotations.Nullable;

public class SecuredHoconPresentation
implements ConfigurationPresentation<String> {
    private final HoconPresentation delegateHoconPresentation;
    private final Authorizer authorizer;
    private final Action readAction;
    private final Action writeAction;

    public SecuredHoconPresentation(HoconPresentation delegateHoconPresentation, Authorizer authorizer, Action readAction, Action writeAction) {
        this.delegateHoconPresentation = delegateHoconPresentation;
        this.authorizer = authorizer;
        this.readAction = readAction;
        this.writeAction = writeAction;
    }

    @Override
    public String represent() {
        return this.authorizer.authorize(this.readAction, this.delegateHoconPresentation::represent);
    }

    @Override
    public String representByPath(@Nullable String path) {
        return this.authorizer.authorize(this.readAction, () -> this.delegateHoconPresentation.representByPath(path));
    }

    @Override
    public CompletableFuture<Void> update(String cfgUpdate) {
        return this.authorizer.authorizeThenCompose(this.writeAction, () -> this.delegateHoconPresentation.update(cfgUpdate));
    }
}

