/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.jwt;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.RestFactory;
import org.apache.ignite3.internal.security.authentication.AuthenticationManager;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.rest.jwt.JwtReader;
import org.gridgain.internal.rest.jwt.JwtValidator;
import org.gridgain.internal.security.jwt.JwtTokenManager;
import org.gridgain.internal.security.jwt.TokenManager;

@Factory
public class JwtRestFactory
implements RestFactory {
    private AuthenticationManager authenticationManager;
    private JwtTokenManager tokenManagement;
    private JwtValidator jwtValidator;
    private LicenseFeatureChecker licenseFeatureChecker;
    private JwtReader jwtReader;

    public JwtRestFactory(AuthenticationManager authenticationManager, LicenseFeatureChecker licenseFeatureChecker, JwtTokenManager tokenManager) {
        this.authenticationManager = authenticationManager;
        this.tokenManagement = tokenManager;
        this.jwtValidator = new JwtValidator(tokenManager, licenseFeatureChecker);
        this.jwtReader = new JwtReader();
    }

    @Singleton
    @Bean
    public JwtValidator jwtValidator() {
        return this.jwtValidator;
    }

    @Singleton
    @Bean
    public JwtReader jwtResolver() {
        return this.jwtReader;
    }

    @Singleton
    @Bean
    public AuthenticationManager authenticationManager() {
        return this.authenticationManager;
    }

    @Singleton
    @Bean
    public TokenManager tokenManagement() {
        return this.tokenManagement;
    }

    @Override
    public void cleanResources() {
        this.authenticationManager = null;
        this.tokenManagement = null;
        this.jwtValidator = null;
        this.jwtReader = null;
    }
}

