/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.assignments;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.rbac.AssignmentOperationResult;
import org.gridgain.internal.rbac.assignments.RoleAssignment;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.store.LowerCaseString;
import org.gridgain.internal.rbac.store.OperationResult;
import org.gridgain.internal.rbac.store.OperationResultContainer;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserStore;

public class RoleAssignmentImpl
implements RoleAssignment {
    private final UserStore userStore;
    private final RoleStore roleStore;

    public RoleAssignmentImpl(UserStore userStore, RoleStore roleStore) {
        this.userStore = userStore;
        this.roleStore = roleStore;
    }

    @Override
    public CompletableFuture<OperationResultContainer<AssignmentOperationResult>> assign(Set<String> assignRoles, Set<String> assignUsers) {
        Set<LowerCaseString> usernames = this.userStore.getAllWithKeys().keySet();
        Set<LowerCaseString> roleNames = this.roleStore.getAllWithKeys().keySet();
        Set<String> missingRoles = RoleAssignmentImpl.findMissing(roleNames, assignRoles);
        if (!missingRoles.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.ROLE_NOT_FOUND, AssignmentOperationResult.rolesNotFound(missingRoles)));
        }
        Set<String> missingUsers = RoleAssignmentImpl.findMissing(usernames, assignUsers);
        if (!missingUsers.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.USER_NOT_FOUND, AssignmentOperationResult.usersNotFound(missingUsers)));
        }
        Stream<CompletableFuture> futures = assignUsers.stream().map(assignUser -> this.userStore.updateIfExists((String)assignUser, user -> User.builderFrom(user).addRoles(assignRoles).build()));
        return CompletableFutures.allOf(futures).thenApply(unused -> OperationResultContainer.success(null));
    }

    @Override
    public CompletableFuture<OperationResultContainer<AssignmentOperationResult>> revoke(Set<String> revokeRoles, Set<String> revokeUsers) {
        Map users = this.userStore.getAllWithKeys();
        Set<LowerCaseString> roleNames = this.roleStore.getAllWithKeys().keySet();
        Set<String> missingRoles = RoleAssignmentImpl.findMissing(roleNames, revokeRoles);
        if (!missingRoles.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.ROLE_NOT_FOUND, AssignmentOperationResult.rolesNotFound(missingRoles)));
        }
        Set<String> missingUsers = RoleAssignmentImpl.findMissing(users.keySet(), revokeUsers);
        if (!missingUsers.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.USER_NOT_FOUND, AssignmentOperationResult.usersNotFound(missingUsers)));
        }
        HashMap<String, Set<String>> missingAssignments = new HashMap<String, Set<String>>();
        for (String revokeUsername2 : revokeUsers) {
            User revokeUser = (User)users.get(LowerCaseString.from(revokeUsername2));
            if (revokeUser.roles().containsAll(revokeRoles)) continue;
            HashSet<String> roles = new HashSet<String>(revokeRoles);
            roles.removeAll(revokeUser.roles());
            missingAssignments.put(revokeUsername2, roles);
        }
        if (!missingAssignments.isEmpty()) {
            return CompletableFuture.completedFuture(OperationResultContainer.create(OperationResult.RA_NOT_FOUND, AssignmentOperationResult.assignmentsNotFound(missingAssignments)));
        }
        Stream<CompletableFuture> futures = revokeUsers.stream().map(revokeUsername -> this.userStore.updateIfExists((String)revokeUsername, user -> User.builderFrom(user).removeRoles(revokeRoles).build()));
        return CompletableFutures.allOf(futures).thenApply(unused -> OperationResultContainer.success(null));
    }

    private static Set<String> findMissing(Set<LowerCaseString> allElements, Set<String> required) {
        return required.stream().map(LowerCaseString::from).filter(s -> !allElements.contains(s)).map(LowerCaseString::value).collect(Collectors.toSet());
    }
}

