/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.metastorage;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.gridgain.internal.pitr.metastorage.PitrLocalState;
import org.gridgain.internal.pitr.metastorage.PitrProgressDetails;
import org.gridgain.internal.pitr.metastorage.PitrStatus;
import org.gridgain.internal.recovery.progress.RecoveryProgressHandler;

class PitrLocalProgressHandler
implements RecoveryProgressHandler {
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final PitrLocalState state;

    PitrLocalProgressHandler(PitrLocalState state) {
        this.state = state;
    }

    @Override
    public void handlePartitionRecoveryFinished(int tableId, int partition, long rowsUpdated, long recoveryTime) {
    }

    @Override
    public void handleTableRecoveryFinished(int tableId, long rowsUpdated, long recoveryTime) {
        this.state.tables().computeIfAbsent(tableId, id -> new PitrProgressDetails(rowsUpdated));
    }

    @Override
    public void handleRecoveryFinished(long rowsUpdated, long recoveryTime) {
        this.state.setTotal(new PitrProgressDetails(rowsUpdated));
        this.completionFuture.complete(null);
    }

    @Override
    public void handleRecoveryException(Throwable ex) {
        this.completionFuture.completeExceptionally(ex);
    }

    CompletableFuture<PitrLocalState> localState() {
        return this.completionFuture.handle((unused, ex) -> {
            if (ex == null) {
                assert (this.state.total().rowsUpdated() >= 0L);
                this.state.setStatus(PitrStatus.COMPLETED);
            } else {
                this.state.setStatus(PitrStatus.FAILED);
                this.state.setDescription(IgniteStringFormatter.format("{}: {}", ex.getClass(), ex.getMessage()));
            }
            return this.state;
        });
    }
}

