/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.Map;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesTypeInfos;
import org.gridgain.internal.pitr.message.StateResponseMessage;
import org.gridgain.internal.pitr.message.StateResponseMessageBuilder;
import org.gridgain.internal.pitr.metastorage.PitrStatus;

class StateResponseMessageDeserializer
implements MessageDeserializer<StateResponseMessage> {
    private final StateResponseMessageBuilder msg;

    StateResponseMessageDeserializer(PointInTimeRecoveryMessagesFactory messageFactory) {
        this.msg = messageFactory.stateResponseMessage();
    }

    @Override
    public Class<StateResponseMessage> klass() {
        return StateResponseMessage.class;
    }

    @Override
    public StateResponseMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PointInTimeRecoveryMessagesTypeInfos.stateResponseMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("description");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.description(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readMap("progress", MessageCollectionItemType.STRING, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.progress((Map<String, Long>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 2: {
                PitrStatus tmp;
                int shiftedId = reader.readInt("status");
                if (!reader.isLastRead()) {
                    return false;
                }
                PitrStatus pitrStatus = tmp = shiftedId == 0 ? null : PitrStatus.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.status(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(StateResponseMessage.class);
    }
}

