/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.sql.SqlCommon;
import org.apache.ignite3.lang.util.IgniteNameUtils;

public final class TableName
implements Serializable {
    private static final long serialVersionUID = -7010846900894818594L;
    private final String schema;
    private final String name;

    public static Set<TableName> from(Set<String> tableNames) {
        return tableNames.stream().map(TableName::new).collect(Collectors.toSet());
    }

    public TableName(String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    private TableName(String qualifiedName) {
        List<String> names = IgniteNameUtils.parseName(qualifiedName);
        String schema = names.size() > 1 ? names.get(0) : SqlCommon.DEFAULT_SCHEMA_NAME;
        String name = names.size() > 1 ? names.get(1) : names.get(0);
        this.schema = schema;
        this.name = name;
    }

    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableName)) {
            return false;
        }
        TableName tableName = (TableName)o;
        return Objects.equals(this.schema, tableName.schema) && Objects.equals(this.name, tableName.name);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.schema);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public String toString() {
        return IgniteNameUtils.canonicalName(this.schema, this.name);
    }
}

