/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogApplyResult;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.pitr.CoordinatorState;
import org.gridgain.internal.pitr.PitrManagerContext;
import org.gridgain.internal.pitr.PitrUtils;
import org.gridgain.internal.pitr.TableName;
import org.gridgain.internal.pitr.catalog.CreateTempTablesCommand;
import org.gridgain.internal.pitr.catalog.TablesAccessCommand;
import org.gridgain.internal.pitr.exception.PitrException;
import org.gridgain.internal.pitr.message.RecoveryRequestMessage;
import org.gridgain.internal.pitr.metastorage.PitrGlobalState;
import org.gridgain.internal.pitr.metastorage.PitrLocalStateWatch;
import org.gridgain.internal.pitr.metastorage.PitrMetaStorageKeys;
import org.gridgain.internal.pitr.metastorage.PitrStatus;

class PitrOperation {
    private static final IgniteLogger LOG = Loggers.forClass(PitrOperation.class);
    private final PitrManagerContext context;
    private final CoordinatorState coordinatorState;

    PitrOperation(PitrManagerContext context, CoordinatorState coordinatorState) {
        this.context = context;
        this.coordinatorState = coordinatorState;
    }

    CompletableFuture<Void> prepare(RecoveryRequestMessage message, UUID operationId, Set<String> nodeNames) {
        return IgniteUtils.inBusyLockAsync(this.context.busyLock(), () -> {
            Set<TableName> tableNames = TableName.from(message.tableNames());
            int requestedCatalogVersion = this.context.catalogManager().activeCatalogVersion(message.timestampLong());
            Catalog requestedCatalog = this.context.catalogManager().catalog(requestedCatalogVersion);
            assert (requestedCatalog != null) : requestedCatalogVersion;
            for (TableName table : tableNames) {
                CatalogSchemaDescriptor schema = this.context.catalogManager().activeCatalog(message.timestampLong()).schema(table.schema());
                if (schema != null && schema.table(table.name()) != null) continue;
                return CompletableFuture.failedFuture(new PitrException(IgniteStringFormatter.format("Unable to start point in time recovery. There's no table {} at the given timestamp: {}", table.name(), message.timestamp())));
            }
            PitrGlobalState preparedState = new PitrGlobalState(PitrStatus.PREPARED, operationId, nodeNames, tableNames, message.timestamp(), "", -1, null);
            return this.init(preparedState).thenComposeAsync(unused -> {
                PitrLocalStateWatch localStateWatch = new PitrLocalStateWatch(this.context, this.coordinatorState, preparedState);
                return this.start(localStateWatch, preparedState, requestedCatalog);
            }, (Executor)this.context.threadPool());
        });
    }

    private CompletableFuture<Void> init(PitrGlobalState state) {
        List tableKeys = state.tables().stream().map(PitrMetaStorageKeys::buildTableLockKey).collect(Collectors.toUnmodifiableList());
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(Operations.put(PitrMetaStorageKeys.pitrGlobalStateKey(state.operationId()), ByteUtils.toBytes(state)));
        operations.add(Operations.put(PitrMetaStorageKeys.pitrCoordinatorTermKey(state.operationId()), ByteUtils.longToBytesKeepingOrder(this.coordinatorState.term())));
        for (ByteArray tableKey : tableKeys) {
            operations.add(Operations.put(tableKey, ByteUtils.stringToBytes(state.operationId().toString())));
        }
        return ((CompletableFuture)this.context.startOperation().thenCompose(unused -> this.context.metaStorageManager().invoke(PitrOperation.allNotExist(tableKeys), operations, List.of()))).thenAccept(success -> {
            if (!success.booleanValue()) {
                throw new PitrException(IgniteStringFormatter.format("Unable to proceed point in time recovery: concurrent operation detected [ID = {}]", state.operationId()));
            }
        });
    }

    private static Condition allNotExist(List<ByteArray> tableKeys) {
        Condition result = null;
        for (ByteArray tableKey : tableKeys) {
            if (result == null) {
                result = Conditions.notExists(tableKey);
                continue;
            }
            result = Conditions.and(result, Conditions.notExists(tableKey));
        }
        return result;
    }

    CompletableFuture<Void> start(PitrLocalStateWatch localStateWatch, PitrGlobalState state, Catalog catalogToRestore) {
        return ((CompletableFuture)((CompletableFuture)this.lockExistingAndCreateTmpTables(state, catalogToRestore).thenComposeAsync(catalogVersion -> IgniteUtils.inBusyLockAsync(this.context.busyLock(), () -> {
            Catalog catalog = this.context.catalogManager().catalog((int)catalogVersion);
            List<CatalogTableDescriptor> tmpTables = PitrUtils.tmpTableDescriptors(state, catalog);
            this.coordinatorState.rebalanceWatch().addOperation(state.operationId(), tmpTables);
            LOG.info("Starting point in time recovery [ID = {}]", state.operationId());
            PitrGlobalState startedState = new PitrGlobalState(PitrStatus.STARTED, state.operationId(), state.nodeNames(), state.tables(), state.timestamp(), state.description(), (int)catalogVersion, null);
            this.context.metaStorageManager().registerPrefixWatch(PitrMetaStorageKeys.pitrLocalStatePrefix(startedState.operationId()), localStateWatch);
            ByteArray coordinatorTermKey = PitrMetaStorageKeys.pitrCoordinatorTermKey(state.operationId());
            byte[] termBytes = ByteUtils.longToBytesKeepingOrder(this.coordinatorState.term());
            return this.context.metaStorageManager().invoke((Condition)Conditions.value(coordinatorTermKey).le(termBytes), List.of(Operations.put(PitrMetaStorageKeys.pitrGlobalStateKey(startedState.operationId()), ByteUtils.toBytes(startedState)), Operations.put(coordinatorTermKey, termBytes)), List.of());
        }), (Executor)this.context.threadPool())).handle((success, ex) -> {
            if (ex != null) {
                LOG.error("Point in time recovery start failure [ID = {}]", (Throwable)ex, (Object)state.operationId());
                return localStateWatch.onFail(this.context.nodeName(), ex.getMessage());
            }
            if (!success.booleanValue()) {
                LOG.info("Point in time recovery coordinator has changed, process will be completed by the new Coordinator.", new Object[0]);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Integer> lockExistingAndCreateTmpTables(PitrGlobalState state, Catalog catalogToRestore) {
        return this.context.catalogManager().execute(List.of(TablesAccessCommand.lock(state.tables()), new CreateTempTablesCommand("__RECOVERY", state.tables(), catalogToRestore))).thenApply(CatalogApplyResult::getCatalogVersion);
    }
}

