/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.compute.ComputeJob;
import org.apache.ignite3.compute.JobExecutionContext;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.Tuple;
import org.gridgain.internal.ml.IgniteMlImpl;
import org.gridgain.internal.ml.compute.PredictionUtils;
import org.gridgain.ml.InferenceException;
import org.gridgain.ml.compute.MlComputeJob;
import org.gridgain.ml.compute.MlOutputMarshaller;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.jetbrains.annotations.Nullable;

public class MlColocatedPredictionJob<I extends MlColocatedJobParameters, O>
extends MlComputeJob<I, O> {
    public static <I extends MlColocatedJobParameters, O> Class<? extends ComputeJob<I, O>> jobClass() {
        return MlColocatedPredictionJob.class;
    }

    @Override
    public CompletableFuture<O> predictAsync(JobExecutionContext context, @Nullable I arg) {
        if (arg == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        IgniteTables tables = context.ignite().tables();
        Table table = tables.table(((MlColocatedJobParameters)arg).tableName());
        if (table == null) {
            return CompletableFuture.failedFuture(new InferenceException("Table not found: " + ((MlColocatedJobParameters)arg).tableName()));
        }
        RecordView<Tuple> view = table.recordView();
        Tuple resultTuple = view.get(null, ((MlColocatedJobParameters)arg).key());
        if (resultTuple == null) {
            return CompletableFuture.failedFuture(new InferenceException("No record found for key " + ((MlColocatedJobParameters)arg).key() + " in table " + ((MlColocatedJobParameters)arg).tableName()));
        }
        ((MlSimpleJobParameters)arg).setInput(resultTuple.value(((MlColocatedJobParameters)arg).inputColumn()));
        IgniteMlImpl mlImpl = Wrappers.unwrap(context.ignite().ml(), IgniteMlImpl.class);
        Executor executor = mlImpl.executor();
        return PredictionUtils.predictAsyncInternal(arg, executor);
    }

    @Override
    @Nullable
    public Marshaller<O, byte[]> resultMarshaller() {
        return new MlOutputMarshaller();
    }
}

