/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.ml.IgniteMl;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.gridgain.ml.model.MlSqlJobParameters;

public class SecuredIgniteMl
implements IgniteMl,
Wrapper {
    private final IgniteMl delegate;
    private final SecurityContext securityContext;

    public SecuredIgniteMl(IgniteMl delegate, SecurityContext securityContext) {
        this.delegate = delegate;
        this.securityContext = securityContext;
    }

    @Override
    public <I, O> O predict(MlSimpleJobParameters<I> jobParams) {
        return (O)GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predict(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<O> predictAsync(MlSimpleJobParameters<I> jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predictAsync(jobParams));
    }

    @Override
    public <I, O> List<O> batchPredict(MlBatchJobParameters<I> jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.batchPredict(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<List<O>> batchPredictAsync(MlBatchJobParameters<I> jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.batchPredictAsync(jobParams));
    }

    @Override
    public <O> List<O> predictFromSql(MlSqlJobParameters jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predictFromSql(jobParams));
    }

    @Override
    public <O> CompletableFuture<List<O>> predictFromSqlAsync(MlSqlJobParameters jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predictFromSqlAsync(jobParams));
    }

    @Override
    public <I, O> O predictColocated(MlColocatedJobParameters<I> jobParams) {
        return (O)GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predictColocated(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<O> predictColocatedAsync(MlColocatedJobParameters<I> jobParams) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.predictColocatedAsync(jobParams));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.delegate, classToUnwrap);
    }
}

