/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.gridgain.ml.IgniteMl;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.gridgain.ml.model.MlSqlJobParameters;

public class PublicApiThreadingIgniteMl
implements IgniteMl,
Wrapper {
    private final IgniteMl ml;
    private final Executor executor;

    public PublicApiThreadingIgniteMl(IgniteMl ml, Executor executor) {
        this.ml = ml;
        this.executor = executor;
    }

    @Override
    public <I, O> O predict(MlSimpleJobParameters<I> jobParams) {
        return (O)PublicApiThreading.execUserSyncOperation(() -> this.ml.predict(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<O> predictAsync(MlSimpleJobParameters<I> jobParams) {
        return this.ml.predictAsync(jobParams).thenApplyAsync(result -> result, this.executor);
    }

    @Override
    public <I, O> List<O> batchPredict(MlBatchJobParameters<I> jobParams) {
        return PublicApiThreading.execUserSyncOperation(() -> this.ml.batchPredict(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<List<O>> batchPredictAsync(MlBatchJobParameters<I> jobParams) {
        return this.ml.batchPredictAsync(jobParams).thenApplyAsync(result -> result, this.executor);
    }

    @Override
    public <O> List<O> predictFromSql(MlSqlJobParameters jobParams) {
        return PublicApiThreading.execUserSyncOperation(() -> this.ml.predictFromSql(jobParams));
    }

    @Override
    public <O> CompletableFuture<List<O>> predictFromSqlAsync(MlSqlJobParameters jobParams) {
        return this.ml.predictFromSqlAsync(jobParams).thenApplyAsync(result -> result, this.executor);
    }

    @Override
    public <I, O> O predictColocated(MlColocatedJobParameters<I> jobParams) {
        return (O)PublicApiThreading.execUserSyncOperation(() -> this.ml.predictColocated(jobParams));
    }

    @Override
    public <I, O> CompletableFuture<O> predictColocatedAsync(MlColocatedJobParameters<I> jobParams) {
        return this.ml.predictColocatedAsync(jobParams).thenApplyAsync(result -> result, this.executor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.ml, classToUnwrap);
    }
}

