/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.ml.configuration.MlConfiguration;
import org.jetbrains.annotations.Nullable;

public class MlComponent
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(MlComponent.class);
    private static final long THREAD_IDLE_TIMEOUT_SECONDS = 60L;
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 10L;
    private final String nodeName;
    private final MlConfiguration mlConfiguration;
    @Nullable
    private ExecutorService executor;
    private final AtomicBoolean stopGuard = new AtomicBoolean(false);

    public MlComponent(String nodeName, MlConfiguration mlConfiguration) {
        this.nodeName = nodeName;
        this.mlConfiguration = mlConfiguration;
    }

    public Executor executor() {
        if (this.stopGuard.get()) {
            throw new IllegalStateException("MlComponent has been stopped");
        }
        return this.getOrCreateExecutor();
    }

    private synchronized ExecutorService getOrCreateExecutor() {
        if (this.executor == null) {
            int poolSize = (Integer)this.mlConfiguration.threadPoolSize().value();
            LOG.info("Creating ML inference executor with pool size: {}", poolSize);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, poolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), IgniteThreadFactory.create(this.nodeName, "ml-inference", LOG, new ThreadOperation[0]));
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.executor = threadPoolExecutor;
        }
        return this.executor;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        MlComponent mlComponent = this;
        synchronized (mlComponent) {
            if (this.executor != null) {
                LOG.debug("Shutting down ML inference executor", new Object[0]);
                IgniteUtils.shutdownAndAwaitTermination(this.executor, 10L, TimeUnit.SECONDS);
                this.executor = null;
            }
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

