/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.IgniteSystemProperties;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.configuration.LicenseView;
import org.gridgain.internal.license.configuration.validator.License;

public class LicenseContentValidatorImpl
implements Validator<License, LicenseView> {
    public static final LicenseContentValidatorImpl INSTANCE = new LicenseContentValidatorImpl();
    private static final IgniteLogger LOG = Loggers.forClass(LicenseContentValidatorImpl.class);

    @Override
    public void validate(License annotation, ValidationContext<LicenseView> ctx) {
        LicenseView newValue = ctx.getNewValue();
        if (newValue.content().isBlank() && newValue.signature().isBlank()) {
            return;
        }
        List<ValidationIssue> issues = LicenseContentValidatorImpl.verifyLicense(ctx.currentKey(), () -> LicenseWithSignature.parseLicense(newValue.content(), newValue.signature()));
        if (issues.isEmpty()) {
            return;
        }
        String licenseOverridePath = IgniteSystemProperties.getString("GG_LICENSE_OVERRIDE");
        if (licenseOverridePath != null) {
            issues.clear();
            try {
                String license = Files.readString(Path.of(licenseOverridePath, new String[0]));
                LOG.info("Overriding license from file \"{}\"", licenseOverridePath);
                issues = LicenseContentValidatorImpl.verifyLicense(ctx.currentKey(), () -> LicenseWithSignature.parseLicense(license));
            }
            catch (IOException e) {
                String message = IgniteStringFormatter.format("Failed to read license override file \"{}\"", licenseOverridePath);
                LOG.error(message, (Throwable)e);
                issues.add(new ValidationIssue(ctx.currentKey(), message));
            }
        }
        issues.forEach(ctx::addIssue);
    }

    private static List<ValidationIssue> verifyLicense(String currentKey, Supplier<LicenseWithSignature> licenseSupplier) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        try {
            LicenseViolationInfo violationInfo = LicenseValidator.verifyLicense(licenseSupplier.get());
            for (LicenseViolationInfo.LicenseFieldViolationInfo info : violationInfo.getViolations()) {
                issues.add(new ValidationIssue(currentKey, info.errorMessage()));
            }
        }
        catch (LicenseViolationException e) {
            issues.add(new ValidationIssue(currentKey, e.getMessage()));
        }
        return issues;
    }
}

