/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.util.StringUtils;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.gridgain.internal.encryption.utils.KeyProviderValidationUtils;
import org.gridgain.internal.encryption.validator.ActiveProviderValidator;

public class ActiveProviderValidatorImpl
implements Validator<ActiveProviderValidator, String> {
    public static final ActiveProviderValidatorImpl INSTANCE = new ActiveProviderValidatorImpl();

    @Override
    public void validate(ActiveProviderValidator annotation, ValidationContext<String> ctx) {
        EncryptionView encryptionView = (EncryptionView)ctx.getNewOwner();
        boolean enabled = encryptionView.enabled();
        String activeProvider = ctx.getNewValue();
        if (enabled && StringUtils.nullOrBlank(activeProvider)) {
            String message = "Active provider value must not be blank.";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        } else {
            Set keyProviders = encryptionView.providers().stream().map(view -> KeyProviderValidationUtils.normalizeProviderName(view.name())).collect(Collectors.toSet());
            if (!keyProviders.isEmpty() && !keyProviders.contains(KeyProviderValidationUtils.normalizeProviderName(activeProvider))) {
                String message = "Provider \"" + activeProvider + "\" is not present in the provider configuration";
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
            }
        }
    }
}

