/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.configuration.storage.StorageException;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.storage.EncryptedDataEncryptionKeysSerializer;
import org.gridgain.internal.encryption.storage.EncryptedKeyChain;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.gridgain.internal.encryption.storage.KeyChainEncryptor;
import org.gridgain.internal.encryption.storage.KeyStorage;
import org.jetbrains.annotations.Nullable;

public class VaultKeyStorage
implements KeyStorage {
    public static final String ENCRYPTION_KEYS_PREFIX = "table-encryption-keys-";
    private static final ByteArray ENCRYPTION_KEYS_RANGE_START = ByteArray.fromString("table-encryption-keys-");
    private static final ByteArray ENCRYPTION_KEYS_RANGE_END = ByteArray.fromString(StringUtils.incrementLastChar("table-encryption-keys-"));
    private final KeyChainEncryptor encryptor;
    private final VaultManager vaultManager;

    public VaultKeyStorage(VaultManager vaultManager, EncryptionManager encryptionManager) {
        this.vaultManager = vaultManager;
        this.encryptor = new KeyChainEncryptor(encryptionManager);
    }

    @Override
    public void store(String id, KeyChain keyChain) {
        byte[] bytes = VersionedSerialization.toBytes(this.encryptor.encrypt(keyChain), EncryptedDataEncryptionKeysSerializer.INSTANCE);
        this.vaultManager.put(VaultKeyStorage.toVaultKey(id), bytes);
    }

    @Override
    public void storeAll(Map<String, KeyChain> keyChains) {
        Map<ByteArray, byte[]> encryptedKeyChains = keyChains.entrySet().stream().collect(Collectors.toMap(e -> VaultKeyStorage.toVaultKey((String)e.getKey()), e -> VersionedSerialization.toBytes(this.encryptor.encrypt((KeyChain)e.getValue()), EncryptedDataEncryptionKeysSerializer.INSTANCE)));
        this.vaultManager.putAll(encryptedKeyChains);
    }

    @Override
    public void remove(String id) {
        this.vaultManager.remove(VaultKeyStorage.toVaultKey(id));
    }

    @Override
    @Nullable
    public KeyChain getKeyChain(String id) {
        VaultEntry vaultEntry = this.vaultManager.get(VaultKeyStorage.toVaultKey(id));
        return vaultEntry != null ? this.deserialize(vaultEntry.value()) : null;
    }

    @Override
    public Map<String, KeyChain> getKeyChains() {
        Cursor<VaultEntry> cursor = this.vaultManager.range(ENCRYPTION_KEYS_RANGE_START, ENCRYPTION_KEYS_RANGE_END);
        try {
            Map<String, KeyChain> map = cursor.stream().collect(Collectors.toMap(entry -> VaultKeyStorage.removePrefix(entry.key()), entry -> this.deserialize(entry.value())));
            if (cursor != null) {
                cursor.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new StorageException("Failed to restore data encryption keys for tables", e);
            }
        }
    }

    private KeyChain deserialize(byte[] arr) {
        EncryptedKeyChain encryptedKeyChain = VersionedSerialization.fromBytes(arr, EncryptedDataEncryptionKeysSerializer.INSTANCE);
        return this.encryptor.decrypt(encryptedKeyChain);
    }

    private static ByteArray toVaultKey(String chainId) {
        return ByteArray.fromString(ENCRYPTION_KEYS_PREFIX + chainId);
    }

    private static String removePrefix(ByteArray key) {
        return key.toString().substring(ENCRYPTION_KEYS_PREFIX.length());
    }
}

