/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.provider.DataEncryptionKeyWithProvider;
import org.gridgain.internal.encryption.storage.EncryptedKeyChain;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.jetbrains.annotations.Nullable;

public class KeyChainEncryptor {
    private final EncryptionManager encryptionManager;

    public KeyChainEncryptor(EncryptionManager encryptionManager) {
        this.encryptionManager = encryptionManager;
    }

    public EncryptedKeyChain encrypt(KeyChain chain) {
        return new EncryptedKeyChain(chain.activeKey().id(), chain.keys().stream().map(key -> this.doEncrypt((DataEncryptionKey)key, chain.providerName())).collect(Collectors.toUnmodifiableList()));
    }

    public KeyChain decrypt(EncryptedKeyChain chain) {
        List keys = chain.keys().stream().map(this.encryptionManager::decryptDataKeyWithProvider).collect(Collectors.toUnmodifiableList());
        return new KeyChain(chain.activeKeyId(), keys.stream().map(DataEncryptionKeyWithProvider::dataEncryptionKey).collect(Collectors.toUnmodifiableList()), keys.stream().map(DataEncryptionKeyWithProvider::providerName).filter(Objects::nonNull).findFirst().orElse(null));
    }

    private byte[] doEncrypt(DataEncryptionKey key, @Nullable String providerName) {
        if (providerName != null) {
            return this.encryptionManager.encryptDataKeyByProvider(key, providerName);
        }
        return this.encryptionManager.encryptDataKey(key);
    }
}

