/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.tostring.S;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.metastorage.AuthConfigEntry;
import org.gridgain.internal.dcr.metastorage.ExceptionEntry;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayBuilder;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayReader;
import org.gridgain.internal.dcr.metastorage.SslConfigEntry;
import org.jetbrains.annotations.Nullable;

public class ReplicationEntry {
    private final Set<String> sourceClusterAddresses;
    @Nullable
    private final AuthConfigEntry authConfig;
    @Nullable
    private final SslConfigEntry sslConfig;
    private final String sourceClusterName;
    private final String workerNode;
    private final ReplicationStatus status;
    private final String schema;
    @Nullable
    private final Instant flushPoint;
    private final Set<String> replicationNodes;
    @Nullable
    private final ExceptionEntry exception;
    @Nullable
    private final Map<String, ReplicationStatus> tableStatuses;

    private ReplicationEntry(Set<String> sourceClusterAddresses, @Nullable AuthConfigEntry authConfig, @Nullable SslConfigEntry sslConfig, String sourceClusterName, String workerNode, @Nullable String schema, @Nullable Instant flushPoint, Set<String> replicationNodes, ReplicationStatus status, @Nullable ExceptionEntry exception, @Nullable Map<String, ReplicationStatus> tableStatuses) {
        this.sourceClusterAddresses = sourceClusterAddresses;
        this.authConfig = authConfig;
        this.sslConfig = sslConfig;
        this.sourceClusterName = sourceClusterName;
        this.workerNode = workerNode;
        this.schema = schema;
        this.flushPoint = flushPoint;
        this.replicationNodes = replicationNodes;
        this.status = status;
        this.exception = exception;
        this.tableStatuses = tableStatuses;
    }

    public Set<String> sourceClusterAddresses() {
        return this.sourceClusterAddresses;
    }

    @Nullable
    public AuthConfigEntry authConfig() {
        return this.authConfig;
    }

    @Nullable
    public SslConfigEntry sslConfig() {
        return this.sslConfig;
    }

    public String sourceClusterName() {
        return this.sourceClusterName;
    }

    public String workerNode() {
        return this.workerNode;
    }

    public String schema() {
        return this.schema;
    }

    public ReplicationStatus replicationStatus() {
        return this.status;
    }

    public Set<String> replicationNodes() {
        return this.replicationNodes;
    }

    public boolean isRunning() {
        return this.status == ReplicationStatus.REPLICATING && this.tableStatuses != null && this.tableStatuses.containsValue((Object)ReplicationStatus.REPLICATING);
    }

    @Nullable
    public Instant flushPoint() {
        return this.flushPoint;
    }

    @Nullable
    public ExceptionEntry exceptionEntry() {
        return this.exception;
    }

    public Map<String, ReplicationStatus> tableStatuses() {
        return this.tableStatuses;
    }

    public byte[] toByteArray() {
        MetaStoreByteArrayBuilder builder = new MetaStoreByteArrayBuilder();
        long encodedFlushPoint = this.flushPoint != null ? this.flushPoint.toEpochMilli() : -1L;
        return builder.appendCollection(this.sourceClusterAddresses).appendByteArray(this.authConfig != null ? this.authConfig.toByteArray() : new byte[]{}).appendByteArray(this.sslConfig != null ? this.sslConfig.toByteArray() : new byte[]{}).appendString(this.sourceClusterName).appendNullableString(this.workerNode).appendNullableString(this.schema).appendInt(this.status.ordinal()).appendLong(encodedFlushPoint).appendNullableMap(this.tableStatuses).appendByteArray(this.exception != null ? this.exception.toByteArray() : new byte[]{}).appendCollection(this.replicationNodes).build();
    }

    public static ReplicationEntryBuilder builder() {
        return new ReplicationEntryBuilder();
    }

    public ReplicationEntryBuilder toBuilder() {
        return new ReplicationEntryBuilder().sourceClusterAddresses(this.sourceClusterAddresses).authConfig(this.authConfig).sslConfig(this.sslConfig).sourceClusterName(this.sourceClusterName).workerNode(this.workerNode).schema(this.schema).replicationNodes(this.replicationNodes).flushPoint(this.flushPoint).status(this.status).tableStatuses(this.tableStatuses);
    }

    public static ReplicationEntry fromByteArray(byte[] arr) {
        byte[] sslConfigBytes;
        MetaStoreByteArrayReader reader = new MetaStoreByteArrayReader(arr);
        ReplicationEntryBuilder builder = ReplicationEntry.builder().sourceClusterAddresses(reader.readCollection(Collectors.toSet()));
        byte[] authConfigBytes = reader.readByteArray();
        if (authConfigBytes.length > 0) {
            builder.authConfig(AuthConfigEntry.fromByteArray(authConfigBytes));
        }
        if ((sslConfigBytes = reader.readByteArray()).length > 0) {
            builder.sslConfig(SslConfigEntry.fromByteArray(sslConfigBytes));
        }
        builder.sourceClusterName(reader.readString()).workerNode(reader.readString()).schema(reader.readString()).status(ReplicationStatus.values()[reader.readInt()]);
        long flushPointLong = reader.readLong();
        Instant flushPoint = flushPointLong > 0L ? Instant.ofEpochMilli(flushPointLong) : null;
        builder.flushPoint(flushPoint).tableStatuses(reader.readNullableMap());
        byte[] exceptionBytes = reader.readByteArray();
        if (exceptionBytes.length > 0) {
            builder.exception(ExceptionEntry.fromByteArray(exceptionBytes));
        }
        ReplicationEntry replicationEntry = builder.replicationNodes(reader.readCollection(Collectors.toSet())).build();
        assert (!reader.hasNext());
        return replicationEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationEntry that = (ReplicationEntry)o;
        if (!Objects.equals(this.workerNode, that.workerNode)) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (!Objects.equals(this.sourceClusterAddresses, that.sourceClusterAddresses)) {
            return false;
        }
        if (!Objects.equals(this.authConfig, that.authConfig)) {
            return false;
        }
        if (!Objects.equals(this.sslConfig, that.sslConfig)) {
            return false;
        }
        if (!Objects.equals(this.sourceClusterName, that.sourceClusterName)) {
            return false;
        }
        if (!Objects.equals(this.schema, that.schema)) {
            return false;
        }
        if (!Objects.equals(this.flushPoint, that.flushPoint)) {
            return false;
        }
        if (!Objects.equals(this.tableStatuses, that.tableStatuses)) {
            return false;
        }
        if (!Objects.equals(this.replicationNodes, that.replicationNodes)) {
            return false;
        }
        return Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.sourceClusterName, this.workerNode, this.status, this.schema, this.flushPoint, this.replicationNodes, this.exception, this.tableStatuses});
    }

    public String toString() {
        return S.toString(this);
    }

    public static class ReplicationEntryBuilder {
        private Set<String> sourceClusterAddresses;
        @Nullable
        private AuthConfigEntry authConfig;
        @Nullable
        private SslConfigEntry sslConfig;
        private String sourceClusterName;
        private String workerNode;
        private String schema;
        @Nullable
        private Instant flushPoint;
        private ReplicationStatus status = ReplicationStatus.STOPPED;
        private final Set<String> replicationNodes = new HashSet<String>();
        @Nullable
        private ExceptionEntry exceptionEntry;
        @Nullable
        private Map<String, ReplicationStatus> tableStatuses = new HashMap<String, ReplicationStatus>();

        public ReplicationEntryBuilder sourceClusterAddresses(Set<String> sourceClusterAddresses) {
            this.sourceClusterAddresses = sourceClusterAddresses;
            return this;
        }

        public ReplicationEntryBuilder authConfig(@Nullable AuthConfigEntry authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ReplicationEntryBuilder sslConfig(@Nullable SslConfigEntry sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public ReplicationEntryBuilder sourceClusterName(String sourceClusterName) {
            this.sourceClusterName = sourceClusterName;
            return this;
        }

        public ReplicationEntryBuilder workerNode(String workerNode) {
            this.workerNode = workerNode;
            return this;
        }

        public ReplicationEntryBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ReplicationEntryBuilder flushPoint(@Nullable Instant flushPoint) {
            this.flushPoint = flushPoint;
            return this;
        }

        public ReplicationEntryBuilder replicationNodes(@Nullable Set<String> replicationNodes) {
            this.replicationNodes.clear();
            if (replicationNodes != null) {
                this.replicationNodes.addAll(replicationNodes);
            }
            return this;
        }

        public ReplicationEntryBuilder replicationNodes(String ... replicationNodes) {
            return this.replicationNodes(Set.of(replicationNodes));
        }

        public ReplicationEntryBuilder status(ReplicationStatus status) {
            this.status = status;
            return this;
        }

        public ReplicationEntryBuilder exception(@Nullable ExceptionEntry exceptionEntry) {
            this.exceptionEntry = exceptionEntry;
            return this;
        }

        public ReplicationEntryBuilder tableStatuses(@Nullable Map<String, ReplicationStatus> tableStatuses) {
            this.tableStatuses.clear();
            if (tableStatuses != null) {
                this.tableStatuses.putAll(tableStatuses);
            }
            return this;
        }

        public ReplicationEntry build() {
            Objects.requireNonNull(this.sourceClusterAddresses, "Source cluster address must not be null.");
            Objects.requireNonNull(this.sourceClusterName, "Source cluster name must not be null.");
            return new ReplicationEntry(this.sourceClusterAddresses, this.authConfig, this.sslConfig, this.sourceClusterName, this.workerNode, this.schema, this.flushPoint, this.replicationNodes, this.status, this.exceptionEntry, this.tableStatuses);
        }
    }
}

