/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTableConverters;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.cli.core.decorator.Decorator;
import org.apache.ignite3.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite3.internal.cli.util.PlainTableRenderer;
import org.gridgain.internal.cli.call.rbac.user.User;

public class UserListDecorator
implements Decorator<List<User>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"username"};
    private final boolean plain;

    public UserListDecorator(boolean plain) {
        this.plain = plain;
    }

    private static String[][] usersContent(List<User> data) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (User user : data) {
            result.add(new String[]{user.username()});
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }

    @Override
    public TerminalOutput decorate(List<User> data) {
        if (data == null || data.isEmpty()) {
            return () -> "";
        }
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, UserListDecorator.usersContent(data));
        }
        return () -> FlipTableConverters.fromObjects((String[])HEADERS, (Object[][])UserListDecorator.usersContent(data));
    }
}

