/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.list;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.TableDecorator;
import org.gridgain.internal.cli.call.snapshot.SnapshotListCall;
import org.gridgain.internal.cli.commands.snapshot.list.SnapshotListMixin;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Returns a list of snapshots"})
public class SnapshotListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private SnapshotListMixin options;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private SnapshotListCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(clusterUrl -> this.options.buildCallInput((String)clusterUrl)).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show snapshot list")).print(new TableDecorator(this.plain)));
    }
}

