/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.role.CreateRoleCallInput;
import org.gridgain.internal.cli.call.rbac.role.CreateRoleReplCall;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create new role if not exists"})
public class RoleCreateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Role name"})
    private String roleName;
    @Inject
    private CreateRoleReplCall createRoleCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.createRoleCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot create role")).print());
    }

    private CreateRoleCallInput input(String clusterUrl) {
        return CreateRoleCallInput.builder().clusterUrl(clusterUrl).roleName(this.roleName).build();
    }
}

