/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.upgrade;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.UpgradeApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.UpgradeStateResponse;
import org.gridgain.internal.cli.call.upgrade.UpgradeStateCallOutput;

@Singleton
public class UpgradeStateCall
implements Call<UrlCallInput, UpgradeStateCallOutput> {
    private final ApiClientFactory apiClientFactory;

    public UpgradeStateCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<UpgradeStateCallOutput> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            UpgradeStateResponse state = new UpgradeApi(this.apiClientFactory.getClient(clusterUrl)).upgradeState();
            return DefaultCallOutput.success(new UpgradeStateCallOutput(state));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

