/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.rest.client.model.SnapshotListItem;
import org.gridgain.internal.cli.call.snapshot.SnapshotListCallInput;
import org.jetbrains.annotations.Nullable;

class SnapshotListCallUtils {
    private static final String SNAPSHOT_ID_HEADER = "Snapshot ID";
    private static final String PARENT_SNAPSHOT_ID_HEADER = "Parent Snapshot ID";
    private static final String SNAPSHOT_TYPE_HEADER = "Type";
    private static final String SNAPSHOT_CREATION_TIME_HEADER = "Creation Time";
    private static final String SNAPSHOT_PATH_NAME_HEADER = "Source";
    private static final String SNAPSHOT_PATH_TYPE_HEADER = "Path type";
    private static final String SNAPSHOT_PATH_URI_HEADER = "URI";
    private static final String SNAPSHOT_TARGET_NODE_SIZE_HEADER = "Number of target nodes";
    private static final String SNAPSHOT_ACTUAL_NODE_SIZE_HEADER = "Number of actual nodes";
    private static final String SNAPSHOT_TARGET_NODE_NAMES_HEADER = "Target nodes";
    private static final String SNAPSHOT_ACTUAL_NODE_NAMES_HEADER = "Actual nodes";
    private static final String SNAPSHOT_NUMBER_TABLES_HEADER = "Number of tables";
    private static final String SNAPSHOT_TABLE_NAMES_HEADER = "Tables";
    private static final Comparator<SnapshotListItem> SNAPSHOT_LIST_ITEM_COMPARATOR_BY_CREATION_TIME_DESC = Comparator.comparing(SnapshotListItem::getCreationTime).reversed();

    SnapshotListCallUtils() {
    }

    static List<String> outputContent(SnapshotListCallInput input, List<SnapshotListItem> list) {
        ArrayList<SnapshotListItem> copy = new ArrayList<SnapshotListItem>(list);
        copy.sort(SNAPSHOT_LIST_ITEM_COMPARATOR_BY_CREATION_TIME_DESC);
        ArrayList<String> res = new ArrayList<String>();
        for (SnapshotListItem item : copy) {
            SnapshotListCallUtils.addSnapshotListItemToResult(input, item, res);
        }
        return res;
    }

    static List<String> outputHeaders(SnapshotListCallInput input) {
        return SnapshotListCallUtils.outputHeaders(input.isShowNodeNames(), input.isShowTableNames(), input.isShowSnapshotUri());
    }

    private static List<String> outputHeaders(boolean showNodeNames, boolean showTableNames, boolean showSnapshotUri) {
        ArrayList<String> headers = new ArrayList<String>(SnapshotListCallUtils.commonHeaders());
        if (showSnapshotUri) {
            headers.add(SNAPSHOT_PATH_URI_HEADER);
        }
        if (showNodeNames) {
            headers.add(SNAPSHOT_TARGET_NODE_NAMES_HEADER);
            headers.add(SNAPSHOT_ACTUAL_NODE_NAMES_HEADER);
        } else {
            headers.add(SNAPSHOT_TARGET_NODE_SIZE_HEADER);
            headers.add(SNAPSHOT_ACTUAL_NODE_SIZE_HEADER);
        }
        if (showTableNames) {
            headers.add(SNAPSHOT_TABLE_NAMES_HEADER);
        } else {
            headers.add(SNAPSHOT_NUMBER_TABLES_HEADER);
        }
        return headers;
    }

    private static List<String> commonHeaders() {
        return List.of(SNAPSHOT_ID_HEADER, PARENT_SNAPSHOT_ID_HEADER, SNAPSHOT_TYPE_HEADER, SNAPSHOT_CREATION_TIME_HEADER, SNAPSHOT_PATH_NAME_HEADER, SNAPSHOT_PATH_TYPE_HEADER);
    }

    private static void addSnapshotListItemToResult(SnapshotListCallInput input, SnapshotListItem item, List<String> res) {
        res.add(item.getId().toString());
        res.add(SnapshotListCallUtils.emptyIfNull(item.getParentId()));
        res.add(item.getType().toString());
        res.add(SnapshotListCallUtils.createTimeToString(item.getCreationTime()));
        res.add(item.getUriName());
        res.add(item.getUriType().name());
        if (input.isShowSnapshotUri()) {
            res.add(item.getUri());
        }
        if (input.isShowNodeNames()) {
            res.add(String.join((CharSequence)",", SnapshotListCallUtils.copyOfSorted(item.getTargetNodeNames())));
            res.add(String.join((CharSequence)",", SnapshotListCallUtils.copyOfSorted(item.getActualNodeNames())));
        } else {
            res.add(Integer.toString(item.getTargetNodeSize()));
            res.add(Integer.toString(item.getActualNodeSize()));
        }
        if (input.isShowTableNames()) {
            res.add(String.join((CharSequence)",", SnapshotListCallUtils.copyOfSorted(item.getTableNames())));
        } else {
            res.add(Integer.toString(item.getTableNumber()));
        }
    }

    private static List<String> copyOfSorted(List<String> list) {
        ArrayList<String> res = new ArrayList<String>(list);
        res.sort(String::compareTo);
        return res;
    }

    private static String emptyIfNull(@Nullable Object content) {
        return content == null ? "" : content.toString();
    }

    private static String createTimeToString(long time) {
        return Instant.ofEpochMilli(HybridTimestamp.hybridTimestamp(time).getPhysical()).atOffset(ZoneOffset.UTC).toString();
    }
}

