/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.role;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RoleAssignmentsApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.RoleView;
import org.apache.ignite3.rest.client.model.User;
import org.gridgain.internal.cli.call.rbac.privilege.Privilege;
import org.gridgain.internal.cli.call.rbac.role.ListRolesCallInput;
import org.gridgain.internal.cli.call.rbac.role.Role;

@Singleton
public class ListRolesCall
implements Call<ListRolesCallInput, List<Role>> {
    private final ApiClientFactory apiClientFactory;

    public ListRolesCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<List<Role>> execute(ListRolesCallInput input) {
        try {
            List<Role> roles = this.listRolesRest(input);
            return DefaultCallOutput.success(roles);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.url()));
        }
    }

    private List<Role> listRolesRest(ListRolesCallInput input) throws ApiException {
        RoleAssignmentsApi roleAssignmentsApi = new RoleAssignmentsApi(this.apiClientFactory.getClient(input.url()));
        boolean noFilter = input.filterByUsername() == null;
        return roleAssignmentsApi.getRoleViews().stream().filter(dto -> noFilter || ListRolesCall.userAssigned(input.filterByUsername(), dto)).map(roleViewDto -> Role.builder().roleName(roleViewDto.getRole()).assignedUsers(ListRolesCall.users(roleViewDto)).privileges(ListRolesCall.privileges(roleViewDto)).build()).collect(Collectors.toList());
    }

    private static boolean userAssigned(String username, RoleView dto) {
        return dto.getUsers().stream().anyMatch(user -> username.equals(user.getUsername()));
    }

    private static List<String> users(RoleView roleViewDto) {
        if (roleViewDto.getUsers() == null) {
            return List.of();
        }
        return roleViewDto.getUsers().stream().map(User::getUsername).collect(Collectors.toList());
    }

    private static List<Privilege> privileges(RoleView roleViewDto) {
        if (roleViewDto.getPrivileges() == null) {
            return List.of();
        }
        return roleViewDto.getPrivileges().stream().map(privilege -> Privilege.builder().action(privilege.getAction()).selector(privilege.getOn()).build()).collect(Collectors.toList());
    }
}

