/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.role;

import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.PrivilegesGrantsApi;
import org.apache.ignite3.rest.client.api.RoleAssignmentsApi;
import org.apache.ignite3.rest.client.api.RoleManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.User;
import org.gridgain.internal.cli.call.rbac.privilege.Privilege;
import org.gridgain.internal.cli.call.rbac.role.Role;
import org.gridgain.internal.cli.call.rbac.role.ShowRoleCallInput;

@Singleton
public class GetRoleCall
implements Call<ShowRoleCallInput, Role> {
    private final ApiClientFactory apiClientFactory;

    public GetRoleCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<Role> execute(ShowRoleCallInput input) {
        String clusterUrl = input.url();
        try {
            Role role = this.getRoleRest(clusterUrl, input.roleName());
            List<String> users = input.showUsers() ? this.getAssignedUsersRest(clusterUrl, input.roleName()) : Collections.emptyList();
            List<Privilege> privileges = input.showPrivileges() ? this.getPrivilegesRest(clusterUrl, input.roleName()) : Collections.emptyList();
            return DefaultCallOutput.success(Role.builderFrom(role).assignedUsers(users).privileges(privileges).build());
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private Role getRoleRest(String clusterUrl, String roleName) throws ApiException {
        org.apache.ignite3.rest.client.model.Role roleDto = new RoleManagementApi(this.apiClientFactory.getClient(clusterUrl)).getRole(roleName);
        return Role.builder().roleName(roleDto.getRoleName()).build();
    }

    private List<String> getAssignedUsersRest(String clusterUrl, String roleName) throws ApiException {
        return new RoleAssignmentsApi(this.apiClientFactory.getClient(clusterUrl)).getUsersByRole(roleName).stream().map(User::getUsername).collect(Collectors.toList());
    }

    private List<Privilege> getPrivilegesRest(String clusterUrl, String roleName) throws ApiException {
        return new PrivilegesGrantsApi(this.apiClientFactory.getClient(clusterUrl)).getPrivileges(roleName).stream().map(it -> Privilege.builder().action(it.getAction()).selector(it.getOn()).build()).collect(Collectors.toList());
    }
}

