/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.replication;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.cdc.replication.ReplicationNameCallInput;

@Singleton
public class StatusReplicationCall
implements Call<ReplicationNameCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public StatusReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(ReplicationNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            DefaultCallOutput.success(new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).getCdcReplication(input.name()));
            return DefaultCallOutput.success("Status ok.");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

