/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core.exec;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.table.QualifiedName;
import org.gridgain.internal.cdc.core.exec.CdcReplicationSubscriber;
import org.jetbrains.annotations.Nullable;

class LocalSubscribersRegistry {
    private final Map<String, Map<QualifiedName, CdcReplicationSubscriber>> runningReplications = new ConcurrentHashMap<String, Map<QualifiedName, CdcReplicationSubscriber>>();

    LocalSubscribersRegistry() {
    }

    void save(String replicationName, Map<QualifiedName, CdcReplicationSubscriber> subscribersByTableName) {
        this.runningReplications.computeIfAbsent(replicationName, k -> new ConcurrentHashMap()).putAll(subscribersByTableName);
    }

    Map<QualifiedName, CdcReplicationSubscriber> getByReplicationName(String replicationName) {
        return this.runningReplications.getOrDefault(replicationName, Map.of());
    }

    @Nullable
    Map<QualifiedName, CdcReplicationSubscriber> removeByReplicationName(String replicationName) {
        return this.runningReplications.remove(replicationName);
    }
}

