/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexResponseSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class ReadIndexResponseImpl
implements RpcRequests.ReadIndexResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3013;
    @IgniteToStringInclude
    private final long index;
    @IgniteToStringInclude
    private final boolean success;

    private ReadIndexResponseImpl(long index, boolean success) {
        this.index = index;
        this.success = success;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    public MessageSerializer serializer() {
        return ReadIndexResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ReadIndexResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3013;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadIndexResponseImpl otherMessage = (ReadIndexResponseImpl)other;
        return this.index == otherMessage.index && this.success == otherMessage.success;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.index, this.success);
        return result;
    }

    @Override
    public ReadIndexResponseImpl clone() {
        try {
            return (ReadIndexResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadIndexResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ReadIndexResponseBuilder {
        private long index;
        private boolean success;

        private Builder() {
        }

        @Override
        public ReadIndexResponseBuilder index(long index) {
            this.index = index;
            return this;
        }

        @Override
        public ReadIndexResponseBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public boolean success() {
            return this.success;
        }

        @Override
        public RpcRequests.ReadIndexResponse build() {
            return new ReadIndexResponseImpl(this.index, this.success);
        }

        @Override
        public RpcRequests.ReadIndexResponse buildDeserialized() {
            return new ReadIndexResponseImpl(this.index, this.success);
        }
    }
}

