/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class ReadIndexResponseDeserializer
implements MessageDeserializer<RpcRequests.ReadIndexResponse> {
    private final ReadIndexResponseBuilder msg;

    ReadIndexResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readIndexResponse();
    }

    @Override
    public Class<RpcRequests.ReadIndexResponse> klass() {
        return RpcRequests.ReadIndexResponse.class;
    }

    @Override
    public RpcRequests.ReadIndexResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.readIndexResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("index");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.index(tmp);
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("success");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.success(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ReadIndexResponse.class);
    }
}

