/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.LeaderChangeNotificationBuilder;
import org.apache.ignite3.raft.jraft.rpc.LeaderChangeNotificationSerializer;

public class LeaderChangeNotificationImpl
implements CliRequests.LeaderChangeNotification,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1021;
    @IgniteToStringInclude
    private ReplicationGroupId groupId;
    private byte[] groupIdByteArray;
    @IgniteToStringInclude
    private final long term;

    private LeaderChangeNotificationImpl(ReplicationGroupId groupId, byte[] groupIdByteArray, long term) {
        if (groupId == null && groupIdByteArray == null) {
            throw new NullPointerException("groupId is not marked @Nullable");
        }
        this.groupId = groupId;
        this.groupIdByteArray = groupIdByteArray;
        this.term = term;
    }

    byte[] groupIdByteArray() {
        return this.groupIdByteArray;
    }

    @Override
    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    @Override
    public long term() {
        return this.term;
    }

    public MessageSerializer serializer() {
        return LeaderChangeNotificationSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(LeaderChangeNotificationImpl.class, this);
    }

    @Override
    public short messageType() {
        return 1021;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LeaderChangeNotificationImpl otherMessage = (LeaderChangeNotificationImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.groupId);
        return result;
    }

    @Override
    public LeaderChangeNotificationImpl clone() {
        try {
            return (LeaderChangeNotificationImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LeaderChangeNotificationBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject groupIdByteArraymo = marshaller.marshal(this.groupId);
        usedDescriptors.addAll((IntCollection)groupIdByteArraymo.usedDescriptorIds());
        this.groupIdByteArray = groupIdByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.groupId = (ReplicationGroupId)marshaller.unmarshal(this.groupIdByteArray, descriptorsObj);
        this.groupIdByteArray = null;
    }

    private static class Builder
    implements LeaderChangeNotificationBuilder {
        private ReplicationGroupId groupId;
        private byte[] groupIdByteArray;
        private long term;

        private Builder() {
        }

        @Override
        public LeaderChangeNotificationBuilder groupId(ReplicationGroupId groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public LeaderChangeNotificationBuilder groupIdByteArray(byte[] groupIdByteArray) {
            this.groupIdByteArray = groupIdByteArray;
            return this;
        }

        @Override
        public LeaderChangeNotificationBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public ReplicationGroupId groupId() {
            return this.groupId;
        }

        @Override
        public byte[] groupIdByteArray() {
            return this.groupIdByteArray;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public CliRequests.LeaderChangeNotification build() {
            return new LeaderChangeNotificationImpl(this.groupId, this.groupIdByteArray, this.term);
        }

        @Override
        public CliRequests.LeaderChangeNotification buildDeserialized() {
            return new LeaderChangeNotificationImpl(this.groupId, this.groupIdByteArray, this.term);
        }
    }
}

