/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.LeaderChangeNotificationBuilder;

class LeaderChangeNotificationDeserializer
implements MessageDeserializer<CliRequests.LeaderChangeNotification> {
    private final LeaderChangeNotificationBuilder msg;

    LeaderChangeNotificationDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.leaderChangeNotification();
    }

    @Override
    public Class<CliRequests.LeaderChangeNotification> klass() {
        return CliRequests.LeaderChangeNotification.class;
    }

    @Override
    public CliRequests.LeaderChangeNotification getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.leaderChangeNotification());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("groupIdByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupIdByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.LeaderChangeNotification.class);
    }
}

