/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.rpc.AppendEntriesRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.AppendEntriesRequestSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class AppendEntriesRequestImpl
implements RpcRequests.AppendEntriesRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3008;
    @IgniteToStringInclude
    private final long committedIndex;
    @IgniteToStringInclude
    private final ByteBuffer data;
    @IgniteToStringInclude
    private final Collection<RaftOutter.EntryMeta> entriesList;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final long prevLogIndex;
    @IgniteToStringInclude
    private final long prevLogTerm;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private AppendEntriesRequestImpl(long committedIndex, ByteBuffer data, Collection<RaftOutter.EntryMeta> entriesList, String groupId, String peerId, long prevLogIndex, long prevLogTerm, String serverId, long term, HybridTimestamp timestamp) {
        this.committedIndex = committedIndex;
        this.data = data;
        this.entriesList = entriesList;
        this.groupId = groupId;
        this.peerId = peerId;
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.serverId = serverId;
        this.term = term;
        this.timestamp = timestamp;
    }

    @Override
    public long committedIndex() {
        return this.committedIndex;
    }

    @Override
    public ByteBuffer data() {
        return this.data;
    }

    @Override
    public Collection<RaftOutter.EntryMeta> entriesList() {
        return this.entriesList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    @Override
    public long prevLogTerm() {
        return this.prevLogTerm;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return AppendEntriesRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(AppendEntriesRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3008;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AppendEntriesRequestImpl otherMessage = (AppendEntriesRequestImpl)other;
        return Objects.equals(this.data, otherMessage.data) && Objects.equals(this.entriesList, otherMessage.entriesList) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.committedIndex == otherMessage.committedIndex && this.prevLogIndex == otherMessage.prevLogIndex && this.prevLogTerm == otherMessage.prevLogTerm && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.committedIndex, this.prevLogIndex, this.prevLogTerm, this.term, this.data, this.entriesList, this.groupId, this.peerId, this.serverId, this.timestamp);
        return result;
    }

    @Override
    public AppendEntriesRequestImpl clone() {
        try {
            return (AppendEntriesRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AppendEntriesRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.entriesList != null) {
            for (RaftOutter.EntryMeta obj : this.entriesList) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.entriesList != null) {
            for (RaftOutter.EntryMeta obj : this.entriesList) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements AppendEntriesRequestBuilder {
        private long committedIndex;
        private ByteBuffer data;
        private Collection<RaftOutter.EntryMeta> entriesList;
        private String groupId;
        private String peerId;
        private long prevLogIndex;
        private long prevLogTerm;
        private String serverId;
        private long term;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public AppendEntriesRequestBuilder committedIndex(long committedIndex) {
            this.committedIndex = committedIndex;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder data(ByteBuffer data) {
            this.data = data;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder entriesList(Collection<RaftOutter.EntryMeta> entriesList) {
            this.entriesList = entriesList;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder prevLogIndex(long prevLogIndex) {
            this.prevLogIndex = prevLogIndex;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder prevLogTerm(long prevLogTerm) {
            this.prevLogTerm = prevLogTerm;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder serverId(String serverId) {
            Objects.requireNonNull(serverId, "serverId is not marked @Nullable");
            this.serverId = serverId;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public AppendEntriesRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public long committedIndex() {
            return this.committedIndex;
        }

        @Override
        public ByteBuffer data() {
            return this.data;
        }

        @Override
        public Collection<RaftOutter.EntryMeta> entriesList() {
            return this.entriesList;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public long prevLogIndex() {
            return this.prevLogIndex;
        }

        @Override
        public long prevLogTerm() {
            return this.prevLogTerm;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public RpcRequests.AppendEntriesRequest build() {
            return new AppendEntriesRequestImpl(this.committedIndex, this.data, this.entriesList, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"), this.prevLogIndex, this.prevLogTerm, Objects.requireNonNull(this.serverId, "serverId is not marked @Nullable"), this.term, this.timestamp);
        }

        @Override
        public RpcRequests.AppendEntriesRequest buildDeserialized() {
            return new AppendEntriesRequestImpl(this.committedIndex, this.data, this.entriesList, this.groupId, this.peerId, this.prevLogIndex, this.prevLogTerm, this.serverId, this.term, this.timestamp);
        }
    }
}

