/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.LocalStorageOutter;
import org.apache.ignite3.raft.jraft.entity.StablePBMetaBuilder;

class StablePBMetaDeserializer
implements MessageDeserializer<LocalStorageOutter.StablePBMeta> {
    private final StablePBMetaBuilder msg;

    StablePBMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.stablePBMeta();
    }

    @Override
    public Class<LocalStorageOutter.StablePBMeta> klass() {
        return LocalStorageOutter.StablePBMeta.class;
    }

    @Override
    public LocalStorageOutter.StablePBMeta getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.stablePBMeta());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("votedFor");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.votedFor(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalStorageOutter.StablePBMeta.class);
    }
}

