/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaBuilder;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaOutter;

class LocalFileMetaDeserializer
implements MessageDeserializer<LocalFileMetaOutter.LocalFileMeta> {
    private final LocalFileMetaBuilder msg;

    LocalFileMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.localFileMeta();
    }

    @Override
    public Class<LocalFileMetaOutter.LocalFileMeta> klass() {
        return LocalFileMetaOutter.LocalFileMeta.class;
    }

    @Override
    public LocalFileMetaOutter.LocalFileMeta getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.localFileMeta());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("checksum");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.checksum(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("sourceNumber");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.sourceNumber(tmp);
                reader.incrementState();
            }
            case 2: {
                byte[] tmp = reader.readByteArray("userMeta");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userMeta(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalFileMetaOutter.LocalFileMeta.class);
    }
}

