/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.FileImpl;
import org.apache.ignite3.raft.jraft.entity.LocalStorageOutter;

class FileSerializer
implements MessageSerializer<LocalStorageOutter.LocalSnapshotPbMeta.File> {
    public static final FileSerializer INSTANCE = new FileSerializer();

    private FileSerializer() {
    }

    @Override
    public boolean writeMessage(LocalStorageOutter.LocalSnapshotPbMeta.File msg, MessageWriter writer) throws MessageMappingException {
        FileImpl message = (FileImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.file());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("meta", message.meta());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("name", message.name());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

