/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.StateMachine;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.conf.Configuration;
import org.apache.ignite3.raft.jraft.entity.LeaderChangeContext;
import org.apache.ignite3.raft.jraft.error.RaftException;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotWriter;

public abstract class StateMachineAdapter
implements StateMachine {
    protected volatile long leaderTerm = -1L;
    private static final IgniteLogger LOG = Loggers.forClass(StateMachineAdapter.class);
    protected final String label;

    public StateMachineAdapter(String label) {
        this.label = label;
    }

    @Override
    public void onShutdown() {
        LOG.info("onShutdown: label={}.", this.label);
    }

    @Override
    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.error("onSnapshotSave");
        this.runClosure(done, "onSnapshotSave");
    }

    @Override
    public boolean onSnapshotLoad(SnapshotReader reader) {
        this.error("onSnapshotLoad", "while a snapshot is saved in " + reader.getPath());
        return false;
    }

    public long getLeaderTerm() {
        return this.leaderTerm;
    }

    @Override
    public void onLeaderStart(long term) {
        this.leaderTerm = term;
        LOG.info("onLeaderStart: term={}, label={}.", term, this.label);
    }

    @Override
    public void onLeaderStop(Status status) {
        LOG.info("onLeaderStop: status={}, label={}.", status, this.label);
    }

    @Override
    public void onError(RaftException e) {
        LOG.error("Encountered an error={} on StateMachine {}, label={}", e, e.getStatus(), this.label);
    }

    @Override
    public void onConfigurationCommitted(Configuration conf) {
        LOG.info("onConfigurationCommitted: {}, label={}.", conf, this.label);
    }

    @Override
    public void onStopFollowing(LeaderChangeContext ctx) {
        LOG.info("onStopFollowing: {}, label={}.", ctx, this.label);
    }

    @Override
    public void onStartFollowing(LeaderChangeContext ctx) {
        LOG.info("onStartFollowing: {}, label={}.", ctx, this.label);
    }

    private void runClosure(Closure done, String methodName) {
        done.run(new Status(-1, "%s doesn't implement %s", this.getClassName(), methodName));
    }

    private String getClassName() {
        return this.getClass().getName();
    }

    private void error(String methodName) {
        this.error(methodName, "");
    }

    private void error(String methodName, String msg) {
        LOG.error("{} doesn't implement {} {}.", this.getClassName(), methodName, msg);
    }
}

