/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.time.Instant;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public final class HybridTimestampUtils {
    public static boolean withinClosedInterval(HybridTimestamp point, HybridTimestamp leftInclusive, HybridTimestamp rightInclusive) {
        return point.compareTo(leftInclusive) >= 0 && point.compareTo(rightInclusive) <= 0;
    }

    public static boolean withinOpenInterval(HybridTimestamp point, HybridTimestamp leftExclusive, HybridTimestamp rightExclusive) {
        return point.compareTo(leftExclusive) > 0 && point.compareTo(rightExclusive) < 0;
    }

    public static boolean withinRightOpenInterval(HybridTimestamp point, HybridTimestamp leftInclusive, HybridTimestamp rightExclusive) {
        return point.compareTo(leftInclusive) >= 0 && point.compareTo(rightExclusive) < 0;
    }

    public static boolean withinLeftOpenInterval(HybridTimestamp point, HybridTimestamp leftExclusive, HybridTimestamp rightInclusive) {
        return point.compareTo(leftExclusive) > 0 && point.compareTo(rightInclusive) <= 0;
    }

    public static HybridTimestamp toHybridTimestamp(Instant instant) {
        return HybridTimestamp.hybridTimestamp(HybridTimestamp.physicalToLong(instant.toEpochMilli()));
    }
}

