/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite3.internal.tx.message.WriteIntentSwitchReplicaRequestImpl;

class WriteIntentSwitchReplicaRequestSerializer
implements MessageSerializer<WriteIntentSwitchReplicaRequest> {
    public static final WriteIntentSwitchReplicaRequestSerializer INSTANCE = new WriteIntentSwitchReplicaRequestSerializer();

    private WriteIntentSwitchReplicaRequestSerializer() {
    }

    @Override
    public boolean writeMessage(WriteIntentSwitchReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        WriteIntentSwitchReplicaRequestImpl message = (WriteIntentSwitchReplicaRequestImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.writeIntentSwitchReplicaRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("commit", message.commit());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeMessage("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeSet("tableIds", message.tableIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

